/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

import chemaxon.license.License;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

class XMLWriter {
    private static final String[] preferredFieldOrder = new String[]{"Software", "License Term", "Licensee", "Number of Users", "Expiration Date", "Support Expiration Date", "Comment", "Hardware"};

    XMLWriter() {
    }

    public String writeXML(Collection<License> licenses) throws Exception {
        ByteArrayOutputStream oStream = new ByteArrayOutputStream();
        this.writeXML(licenses, oStream);
        return oStream.toString();
    }

    public void writeXML(Collection<License> licenses, OutputStream outputStream) throws Exception {
        try (OutputStream outputStream2 = outputStream;){
            this.checkLicense(licenses, outputStream);
        }
    }

    private void checkLicense(Collection<License> licenses, OutputStream outputStream) throws SAXException, IOException, TransformerException, ParserConfigurationException {
        try {
            ByteArrayOutputStream out = this.writeXMLStream(licenses);
            StreamSource license = new StreamSource(new ByteArrayInputStream(out.toByteArray()));
            InputStream is = XMLWriter.class.getResourceAsStream("/chemaxon/LicenseSchema-23.13.xsd");
            StreamSource schemaFile = new StreamSource(is);
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = factory.newSchema(schemaFile);
            Validator validator = schema.newValidator();
            validator.validate(license);
            out.writeTo(outputStream);
        }
        catch (SAXException e) {
            throw new SAXException("Validation of license file failed.", e);
        }
    }

    private ByteArrayOutputStream writeXMLStream(Collection<License> licenses) throws ParserConfigurationException, TransformerException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        Document doc = dbf.newDocumentBuilder().newDocument();
        doc.appendChild(doc.createComment("PLEASE DO NOT MODIFY THIS FILE AND BE AWARE THAT THE FILE CONTAINS CONFIDENTIAL INFORMATION."));
        Element root = doc.createElement("ChemAxon");
        for (License license : licenses) {
            Element le = doc.createElement("License");
            this.writeFields(doc, license, le);
            this.writeRestrictions(doc, license, le);
            this.writeSignature(doc, license, le);
            root.appendChild(le);
        }
        doc.appendChild(root);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer trans = tf.newTransformer();
        trans.setOutputProperty("indent", "yes");
        trans.transform(new DOMSource(doc), new StreamResult(outputStream));
        return outputStream;
    }

    private void writeSignature(Document doc, License license, Element licenseTag) {
        if (license.getSignature() != null) {
            Element sig = doc.createElement("Signature");
            sig.setAttribute("Value", license.getSignature());
            licenseTag.appendChild(sig);
        }
    }

    private void writeRestrictions(Document doc, License license, Element licenseTag) {
        Iterator<String> ri = license.getRestrictionNames().iterator();
        while (ri.hasNext()) {
            Element res = doc.createElement("Restriction");
            String r = ri.next();
            res.setAttribute("Name", r);
            res.setAttribute("Value", license.getRestriction(r));
            licenseTag.appendChild(res);
        }
    }

    private void writeFields(Document doc, License license, Element licenseTag) {
        String[] fieldNames;
        Set<String> fieldNamesSet = license.getFieldNames();
        for (String fieldName : fieldNames = this.sortFieldNamesToPreferredOrder(fieldNamesSet)) {
            Element res = doc.createElement("Field");
            res.setAttribute("Name", fieldName);
            res.setAttribute("Value", license.getFieldValue(fieldName));
            licenseTag.appendChild(res);
        }
    }

    private String[] sortFieldNamesToPreferredOrder(Set<String> fieldNamesSet) {
        HashSet<String> fieldNamesCopy = new HashSet<String>(fieldNamesSet);
        String[] fieldNamesOrdered = new String[fieldNamesCopy.size()];
        int fieldCount = 0;
        for (String fieldName : preferredFieldOrder) {
            if (!fieldNamesSet.contains(fieldName)) continue;
            fieldNamesOrdered[fieldCount++] = fieldName;
            fieldNamesCopy.remove(fieldName);
        }
        Object[] remainingFieldNames = new String[fieldNamesCopy.size()];
        fieldNamesCopy.toArray(remainingFieldNames);
        Arrays.sort(remainingFieldNames);
        for (Object fieldName : remainingFieldNames) {
            fieldNamesOrdered[fieldCount++] = fieldName;
        }
        return fieldNamesOrdered;
    }
}

