/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

import chemaxon.license.License;
import chemaxon.license.LicenseHandler;
import chemaxon.license.TelemetryUtil;
import chemaxon.license.XMLReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

class XMLVerifier {
    private static final Logger verifyLogger = Logger.getLogger("cxl.license.verify");
    private static final String P = "13232376895198612407547930718267435757728527029623408872245156039757713029036368719146452186041204237350521785240337048752071462798273003935646236777459223";
    private static final String Q = "857393771208094202104259627990318636601332086981";
    private static final String G = "5421644057436475141609648488325705128047428394380474376834667300766108262613900542681289080713724597310673074119355136085795982097390670890367185141189796";
    private static final String Y = "10328400754623195006538232250445646173234515198616849995947710377130869330924088628017619811358599344440291439192721234623603691213749518356778136132486588";
    KeyFactory keyFactory = KeyFactory.getInstance("DSA");

    public static void main(String[] args) throws Exception {
        LicenseHandler.getInstance().setSoftwareInformation("Chemaxon", "License XML Verifier");
        try {
            XMLVerifier verifier = new XMLVerifier();
            FileInputStream is = new FileInputStream(args[0]);
            verifier.verifyXML(is);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    XMLVerifier() throws NoSuchAlgorithmException {
    }

    private PublicKey initKey() throws InvalidKeySpecException {
        BigInteger p = new BigInteger(P);
        BigInteger q = new BigInteger(Q);
        BigInteger g = new BigInteger(G);
        BigInteger y = new BigInteger(Y);
        DSAPublicKeySpec pubKS = new DSAPublicKeySpec(y, p, q, g);
        return this.keyFactory.generatePublic(pubKS);
    }

    public Collection<License> verifyXML(InputStream xmlIS) throws Exception {
        XMLReader reader = new XMLReader();
        List<License> licenses = reader.readXML(xmlIS);
        Iterator<License> iterator = licenses.iterator();
        while (iterator.hasNext()) {
            License license = iterator.next();
            boolean signature = this.verify(license.getLicenseData(), license.getSignature());
            boolean hardware = this.verifyHardwareField(license);
            if (signature && hardware) continue;
            if (verifyLogger != null) {
                verifyLogger.severe("License could not be verified:\n" + license.getLicenseData() + "------------------------------");
            }
            iterator.remove();
        }
        return licenses;
    }

    private boolean verify(String data, String textEncodedSign) throws InvalidKeySpecException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (textEncodedSign == null) {
            if (verifyLogger != null) {
                verifyLogger.warning("Signature is missing from the license");
            }
            return false;
        }
        PublicKey publicKey = this.initKey();
        BigInteger sign = new BigInteger(1, Base64.getDecoder().decode(textEncodedSign));
        Signature dsa = Signature.getInstance("SHA1withDSA");
        dsa.initVerify(publicKey);
        dsa.update(data.getBytes(StandardCharsets.UTF_8));
        return true;
    }

    private boolean verifyHardwareField(License license) {
        if (license.getFieldValue("Hardware") != null) {
            String licenseHash = license.getFieldValue("Hardware");
            String currentHash = TelemetryUtil.getHardwareIdV2();
            return licenseHash.equals(currentHash);
        }
        return true;
    }
}

