/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

import chemaxon.common.util.StringTools;
import chemaxon.license.ConditionalExecutor;
import chemaxon.license.License;
import chemaxon.license.LicenseException;
import chemaxon.license.LicenseExceptionHandler;
import chemaxon.license.LicenseProcessingException;
import chemaxon.license.SwitchedOffXercesEnvironment;
import chemaxon.license.XMLWriter;
import com.chemaxon.version.VersionInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class XMLReader {
    private static final Logger generalLogger = Logger.getLogger("cxl.license.general");
    private static final Logger installLogger = Logger.getLogger("cxl.license.install");
    static long LICENSE_READ_TIME_LIMIT = 10000L;
    static ConditionalExecutor executor = new SwitchedOffXercesEnvironment();

    XMLReader() {
    }

    public List<License> readXML(InputStream is) throws Exception {
        int n;
        XMLReader.checkDate(VersionInfo.getBuildTimestamp());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((n = is.read(buf)) >= 0) {
            baos.write(buf, 0, n);
        }
        byte[] content = baos.toByteArray();
        ByteArrayInputStream isCheck = new ByteArrayInputStream(content);
        ByteArrayInputStream isRead = new ByteArrayInputStream(content);
        XMLReader.checkLicense(isCheck);
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        docBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        docBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        docBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        docBuilderFactory.setXIncludeAware(false);
        docBuilderFactory.setExpandEntityReferences(false);
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(isRead);
        Element root = doc.getDocumentElement();
        if (!root.getNodeName().equals("ChemAxon")) {
            return null;
        }
        NodeList licenseNodes = root.getElementsByTagName("License");
        ArrayList<License> licenses = new ArrayList<License>();
        Runnable runnable = () -> {
            try {
                XMLReader.buildLicenseObjects(licenseNodes, licenses);
            }
            catch (LicenseProcessingException e) {
                installLogger.log(Level.INFO, e, () -> " Can not build license object: " + e.getMessage());
                throw new RuntimeException(e);
            }
        };
        Exception[] exception = new Exception[1];
        Thread.UncaughtExceptionHandler uceh = (t, e) -> {
            exception[0] = new RuntimeException(e);
        };
        Thread thread = new Thread(runnable);
        thread.setUncaughtExceptionHandler(uceh);
        thread.start();
        thread.join(LICENSE_READ_TIME_LIMIT);
        if (thread.isAlive()) {
            thread.interrupt();
            LicenseExceptionHandler.getInstance().setLicenseVerificationHasTimeouted(true);
        } else if (exception[0] != null) {
            throw exception[0];
        }
        return licenses;
    }

    private static void buildLicenseObjects(NodeList licenseNodes, List<License> licenses) throws LicenseProcessingException {
        for (int i = 0; i < licenseNodes.getLength(); ++i) {
            License.LicenseBuilder licenseBuilder = License.builder();
            Node licenseNode = licenseNodes.item(i);
            if (licenseNode.getNodeType() == 1) {
                Node sig;
                String value;
                String name;
                Element licenseElement = (Element)licenseNode;
                NodeList fieldList = licenseElement.getElementsByTagName("Field");
                for (int j = 0; j < fieldList.getLength(); ++j) {
                    Node field = fieldList.item(j);
                    if (field.getNodeType() != 1) continue;
                    Element fieldElement = (Element)field;
                    name = fieldElement.getAttribute("Name");
                    value = fieldElement.getAttribute("Value");
                    if (value.isEmpty()) {
                        throw new LicenseProcessingException("Malformed license: missing field value for name: " + name);
                    }
                    licenseBuilder.setField(name, value);
                }
                NodeList resList = licenseElement.getElementsByTagName("Restriction");
                for (int j = 0; j < resList.getLength(); ++j) {
                    Node res = resList.item(j);
                    if (res.getNodeType() != 1) continue;
                    Element resElement = (Element)res;
                    name = resElement.getAttribute("Name");
                    value = resElement.getAttribute("Value");
                    if (value.isEmpty()) {
                        throw new LicenseProcessingException("Malformed license: missing field value for name: " + name);
                    }
                    licenseBuilder.setRestriction(name, value);
                }
                NodeList sigList = licenseElement.getElementsByTagName("Signature");
                if (sigList.getLength() == 1 && (sig = sigList.item(0)).getNodeType() == 1) {
                    Element signature = (Element)sig;
                    licenseBuilder.setSignature(signature.getAttribute("Value"));
                }
            }
            licenses.add(licenseBuilder.build());
        }
    }

    private static void checkLicense(InputStream in) throws Exception {
        try {
            StreamSource license = new StreamSource(in);
            InputStream is = XMLWriter.class.getResourceAsStream("/chemaxon/LicenseSchema-23.13.xsd");
            StreamSource schemaFile = new StreamSource(is);
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = factory.newSchema(schemaFile);
            Validator validator = schema.newValidator();
            executor.execute(() -> {
                validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            });
            validator.validate(license);
        }
        catch (Exception e) {
            generalLogger.log(Level.INFO, e, () -> "Validation of license file failed with: " + e.getMessage());
            throw new Exception("Validation of license file failed.", e);
        }
    }

    private static void checkDate(Date buildDate) {
        Date now = new Date();
        if (now.before(buildDate)) {
            installLogger.warning(() -> "Invalid current date.");
            throw new LicenseException("Invalid current date.");
        }
        installLogger.config(() -> "Valid current date.");
    }

    static {
        try {
            String licenseTimeoutEnv = System.getenv("CXN_LICENSE_TIMEOUT");
            if (!StringTools.isBlank((String)licenseTimeoutEnv)) {
                LICENSE_READ_TIME_LIMIT = Long.parseLong(licenseTimeoutEnv);
            }
        }
        catch (NumberFormatException e) {
            generalLogger.log(Level.INFO, e, () -> "Exception while initializing" + e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
    }
}

