/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

import chemaxon.common.util.DotfileUtil;
import chemaxon.license.HardwareDescriptor;
import chemaxon.license.LicenseHandler;
import chemaxon.license.LicenseManagerProperties;
import chemaxon.license.SoftwareDescriptor;
import chemaxon.license.TelemetryUtil;
import com.chemaxon.version.VersionInfo;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class UserData {
    private HardwareDescriptor hardware;
    private String hostName;
    private SoftwareDescriptor software;
    private String cclVersion;
    private String userName;
    private File cxnHome;
    private String javaProperty;
    private String envVariable;
    private String serverUrlEnvVariable;
    private String licenseKeyEnvVariable;
    private String serverUrl;
    private String licenseKey;
    private File licenseLogFile;
    private final List<String> licenseFiles = new LinkedList<String>();

    protected UserData() {
    }

    public List<String> getLicenseFiles() {
        return this.licenseFiles;
    }

    public String getJavaProperty() {
        return this.javaProperty;
    }

    public String getEnvVariable() {
        return this.envVariable;
    }

    public File getLicenseLogFile() {
        return this.licenseLogFile;
    }

    public File getCxnHome() {
        return this.cxnHome;
    }

    public String getUserName() {
        return this.userName;
    }

    public HardwareDescriptor getHardware() {
        return this.hardware;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getCclVersion() {
        return this.cclVersion;
    }

    public String getServerUrlEnvVariable() {
        return this.serverUrlEnvVariable;
    }

    public String getLicenseKeyEnvVariable() {
        return this.licenseKeyEnvVariable;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getLicenseKey() {
        return this.licenseKey;
    }

    public SoftwareDescriptor getSoftware() {
        return this.software;
    }

    static UserData collect() {
        Map<String, String> environment = System.getenv();
        UserData userData = new UserData();
        userData.userName = System.getProperty("user.name");
        userData.cxnHome = DotfileUtil.getDotDir();
        userData.envVariable = environment.get("CHEMAXON_LICENSE_URL");
        userData.javaProperty = System.getProperty("chemaxon.license.url");
        userData.serverUrlEnvVariable = environment.get("CHEMAXON_LICENSE_SERVER_URL");
        userData.licenseKeyEnvVariable = environment.get("CHEMAXON_LICENSE_SERVER_KEY");
        userData.serverUrl = LicenseManagerProperties.getInstance().getServer();
        userData.licenseKey = LicenseManagerProperties.getInstance().getLicenseKey();
        userData.licenseLogFile = new File(DotfileUtil.getDotDir().getAbsolutePath() + File.separator + "lic.log");
        userData.collectLicenseFiles();
        userData.hardware = TelemetryUtil.getHardwareDescriptor();
        userData.hostName = TelemetryUtil.getHostName();
        userData.software = LicenseHandler.getInstance().getSoftwareDescriptor();
        userData.cclVersion = VersionInfo.getVersion();
        return userData;
    }

    private void collectLicenseFiles() {
        this.getFilesFrom(this.envVariable);
        this.getFilesFrom(this.javaProperty);
        this.readLicenseFilesFromDir(this.cxnHome);
    }

    private void getFilesFrom(String fileList) {
        if (fileList != null && fileList.length() > 0) {
            String[] fileStr;
            for (String s : fileStr = fileList.split(";")) {
                if (this.licenseFiles.contains(s)) continue;
                this.licenseFiles.add(s);
            }
        }
    }

    private void readLicenseFilesFromDir(File dir) {
        if (dir == null) {
            return;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                this.readLicenseFromFile(file);
            }
        }
    }

    private void readLicenseFromFile(File file) {
        if (file.isFile()) {
            if (file.getName().endsWith(".cxl")) {
                this.licenseFiles.add(file.getAbsolutePath());
            }
        } else if (file.isDirectory() && file.getName().equals("licenses")) {
            this.readLicenseFilesFromDir(file);
        }
    }
}

