/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

import chemaxon.license.License;
import chemaxon.license.RemoteLicenseReader;
import chemaxon.license.Resettable;
import chemaxon.license.SoftwareDescriptor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

class ThrottlingRemoteLicenseReader
implements RemoteLicenseReader,
Resettable {
    public static final long DEFAULT_DENIAL_PERIOD = 300000L;
    private final RemoteLicenseReader remoteLicenseReader;
    private final long denialPeriod;
    private final Map<String, ReadRequestEntry> dispatchedReadRequests = new ConcurrentHashMap<String, ReadRequestEntry>();

    ThrottlingRemoteLicenseReader(RemoteLicenseReader remoteLicenseReader) {
        this(remoteLicenseReader, 300000L);
    }

    ThrottlingRemoteLicenseReader(RemoteLicenseReader remoteLicenseReader, long denialPeriod) {
        this.remoteLicenseReader = remoteLicenseReader;
        this.denialPeriod = denialPeriod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCache() {
        long oldest = -1L;
        Map<String, ReadRequestEntry> map = this.dispatchedReadRequests;
        synchronized (map) {
            oldest = this.dispatchedReadRequests.values().stream().mapToLong(ReadRequestEntry::getRequestTime).min().orElse(0L);
        }
        if (this.isTooOld(oldest)) {
            this.dispatchedReadRequests.clear();
            Map<String, ReadRequestEntry> newCache = this.mapLicenses(this.remoteLicenseReader.getAvailableLicenses());
            this.dispatchedReadRequests.putAll(newCache);
        }
    }

    private boolean isTooOld(long timeStamp) {
        return System.currentTimeMillis() - timeStamp > this.denialPeriod;
    }

    @Override
    public List<License> getAvailableLicenses() {
        this.updateCache();
        return this.dispatchedReadRequests.values().stream().filter(rre -> rre.license != null).map(rre -> rre.license).toList();
    }

    @Override
    public RemoteLicenseReader getWrappedRemoteLicenseReader() {
        return this.remoteLicenseReader;
    }

    @Override
    public void reset() {
        this.dispatchedReadRequests.clear();
    }

    @Override
    public void setLicenseContext(SoftwareDescriptor softwareDescriptor) {
        this.remoteLicenseReader.setLicenseContext(softwareDescriptor);
    }

    private Map<String, ReadRequestEntry> mapLicenses(List<License> licenses) {
        long now = System.currentTimeMillis();
        HashMap<String, ReadRequestEntry> result = new HashMap<String, ReadRequestEntry>();
        licenses.forEach(l -> result.compute(l.getSoftware(), (s, current) -> {
            if (current == null || current.license == null) {
                return new ReadRequestEntry(now, (License)l);
            }
            if (l == null) {
                return current;
            }
            if (current.license.getExpirationTime() < l.getExpirationTime()) {
                return new ReadRequestEntry(now, (License)l);
            }
            return current;
        }));
        return result;
    }

    private static class ReadRequestEntry {
        private final long requestTime;
        private final License license;

        ReadRequestEntry(long requestTime, License license) {
            this.requestTime = requestTime;
            this.license = license;
        }

        public Optional<License> getLicense() {
            return Optional.ofNullable(this.license);
        }

        public long getRequestTime() {
            return this.requestTime;
        }
    }
}

