/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

import chemaxon.common.util.Lazy;
import chemaxon.license.HardwareDescriptor;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import oshi.SystemInfo;
import oshi.hardware.Baseboard;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.GraphicsCard;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.PhysicalMemory;

class TelemetryUtil {
    private static final Lazy<String> HARDWARE_ID_V1 = Lazy.of(() -> TelemetryUtil.calculateHardwareId(true), (Lazy.OnFailure)Lazy.OnFailure.RETRY);
    private static final Lazy<String> HARDWARE_ID_V2 = Lazy.of(() -> TelemetryUtil.calculateHardwareId(false), (Lazy.OnFailure)Lazy.OnFailure.RETRY);

    private TelemetryUtil() {
    }

    static String getHardwareIdV1() {
        return (String)HARDWARE_ID_V1.get();
    }

    static String getHardwareIdV2() {
        return (String)HARDWARE_ID_V2.get();
    }

    private static String calculateHardwareId(boolean includeHostName) {
        SystemInfo systemInfo = new SystemInfo();
        Baseboard baseboard = systemInfo.getHardware().getComputerSystem().getBaseboard();
        MessageDigest digest = TelemetryUtil.getMessageDigest();
        String motherboardId = baseboard.getManufacturer() + baseboard.getModel() + baseboard.getVersion() + baseboard.getSerialNumber();
        if (includeHostName) {
            String hostName = systemInfo.getOperatingSystem().getNetworkParams().getHostName();
            return hostName + "@" + TelemetryUtil.getHash(motherboardId + hostName, digest);
        }
        return TelemetryUtil.getHash(motherboardId, digest);
    }

    private static MessageDigest getMessageDigest() {
        try {
            return MessageDigest.getInstance("SHA-512");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getHash(CharSequence cs, MessageDigest digest) {
        byte[] hash = digest.digest(cs.toString().getBytes());
        return TelemetryUtil.bytesToHex(hash);
    }

    static HardwareDescriptor getHardwareDescriptor() {
        MessageDigest digest = TelemetryUtil.getMessageDigest();
        SystemInfo systemInfo = new SystemInfo();
        HardwareAbstractionLayer hardware = systemInfo.getHardware();
        HardwareDescriptor data = new HardwareDescriptor();
        data.setHardwareId(TelemetryUtil.getHardwareIdV2());
        data.setOldHardwareId(TelemetryUtil.getHardwareIdV1());
        data.setVgaId(TelemetryUtil.getVgaId(hardware.getGraphicsCards(), digest));
        data.setMemoryId(TelemetryUtil.getMemoryId(hardware.getMemory(), digest));
        data.setCpuId(TelemetryUtil.cpuId(hardware.getProcessor(), digest));
        data.setHardwareInformationProviderCls(hardware.getClass().toString());
        return data;
    }

    private static String cpuId(CentralProcessor processor, MessageDigest digest) {
        StringBuilder stringBuilder = new StringBuilder();
        CentralProcessor.ProcessorIdentifier proc = processor.getProcessorIdentifier();
        stringBuilder.append(proc.getModel()).append(proc.getName()).append(proc.getVendor());
        return TelemetryUtil.getHash(stringBuilder, digest);
    }

    private static String getMemoryId(GlobalMemory globalMemory, MessageDigest digest) {
        StringBuilder stringBuilder = new StringBuilder();
        List memories = globalMemory.getPhysicalMemory();
        memories.sort(Comparator.comparing(PhysicalMemory::getManufacturer));
        for (PhysicalMemory memory : memories) {
            stringBuilder.append(memory.getManufacturer()).append(memory.getMemoryType()).append(memory.getCapacity());
        }
        return TelemetryUtil.getHash(stringBuilder, digest);
    }

    private static String getVgaId(List<GraphicsCard> graphicsCards, MessageDigest digest) {
        StringBuilder stringBuilder = new StringBuilder();
        graphicsCards.sort(Comparator.comparing(GraphicsCard::getName));
        for (GraphicsCard card : graphicsCards) {
            stringBuilder.append(card.getName()).append(card.getVendor()).append(card.getDeviceId());
        }
        return TelemetryUtil.getHash(stringBuilder, digest);
    }

    private static String bytesToHex(byte[] hash) {
        StringBuilder hexString = new StringBuilder();
        for (byte b : hash) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    static String getHostName() {
        SystemInfo si = new SystemInfo();
        return si.getOperatingSystem().getNetworkParams().getHostName();
    }

    static String getUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }
}

