/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

import chemaxon.license.FileLicenseUsageRepository;
import chemaxon.license.FileUserDataRepository;
import chemaxon.license.JsonChecksumCalculator;
import chemaxon.license.JsonKeyValueChecksumCalculator;
import chemaxon.license.OnlineTelemetryService;
import chemaxon.license.RemoteTelemetryClient;
import chemaxon.license.TelemetryExecutors;
import chemaxon.license.TelemetryFileHandler;
import chemaxon.license.TelemetryProperties;
import chemaxon.license.TelemetryService;
import chemaxon.license.audit.AuditLogStorage;
import chemaxon.license.audit.AuditServiceProvider;
import chemaxon.license.audit.LicenseUsageRepository;
import chemaxon.license.audit.UserDataRepository;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

class TelemetryServiceFactory {
    private static final Logger telemetryLogger = Logger.getLogger("cxl.license.telemetry");

    private TelemetryServiceFactory() {
    }

    static TelemetryService getTelemetryService(TelemetryProperties properties) {
        telemetryLogger.log(Level.FINER, "Create telemetry service.");
        TelemetryServiceFactory.validateProperties(properties);
        if (properties.isTelemetryEnabled()) {
            RemoteTelemetryClient client = new RemoteTelemetryClient(properties.getSessionId(), properties.getServer(), properties.getRemoteClientTimeoutSec());
            return new OnlineTelemetryService(properties.getLicenseKeyProvider(), properties.getSessionId(), client, properties.getUserDataRepositoryGetLimit(), properties.getLicenseUsageRepositoryGetLimit(), TelemetryServiceFactory.getRepository(properties), TelemetryServiceFactory.getExecutors(properties));
        }
        telemetryLogger.log(Level.FINER, "Telemetry collecting is disabled.");
        return new FakeTelemetryService();
    }

    private static AuditLogStorage getRepository(TelemetryProperties properties) {
        Optional dbRepositories = AuditServiceProvider.getInstance().getDatabaseAuditStorage();
        if (dbRepositories.isPresent()) {
            telemetryLogger.log(Level.FINER, "Db repository for telemetry is present.");
        } else {
            telemetryLogger.log(Level.FINER, "Db repository for telemetry is not present, use file repositories.");
        }
        return dbRepositories.orElseGet(() -> new FileAuditLogStorage(properties.getSessionId(), new TelemetryFileHandler(properties.getAuditFilePath(), properties.getAuditFileName()), new JsonKeyValueChecksumCalculator()));
    }

    private static void validateProperties(TelemetryProperties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Telemetry service cannot be created without properties.");
        }
        if (properties.getServer() == null) {
            throw new IllegalArgumentException("Telemetry service cannot be created without server.");
        }
        if (properties.getLicenseKeyProvider() == null) {
            throw new IllegalArgumentException("Telemetry service cannot be created without license key provider function.");
        }
        if (properties.getSessionId() == null) {
            throw new IllegalArgumentException("Telemetry service cannot be created without session id");
        }
        if (properties.getAuditFileName() == null) {
            throw new IllegalArgumentException("Telemetry service cannot be created without audit file name.");
        }
        if (properties.getAuditFilePath() == null) {
            throw new IllegalArgumentException("Telemetry service cannot be created without audit file path.");
        }
    }

    private static ScheduledExecutorService getScheduledExecutorService() {
        ThreadFactory tf = Executors.defaultThreadFactory();
        return Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = tf.newThread(r);
            t.setDaemon(true);
            return t;
        });
    }

    private static TelemetryExecutors getExecutors(TelemetryProperties properties) {
        return new TelemetryExecutors.TelemetryExecutorsBuilder().setSchedulerExecutorService(TelemetryServiceFactory.getScheduledExecutorService()).setExecutorServiceSupplier(Executors::newSingleThreadExecutor).setLicenseUsagePeriodMs(properties.getLicenseUsageCollectPeriodMs()).setLicenseUsageInitialDelayMs(properties.getLicenseUsageCollectInitialDelayMs()).setLocaleUserDataPeriodMs(properties.getLocaleUserDataCollectPeriodMs()).setLocaleUserDataInitialDelayMs(properties.getLocaleUserDataCollectInitialDelayMs()).setLocaleLicenseUsagePeriodMs(properties.getLocaleLicenseUsageCollectPeriodMs()).setLocaleLicenseUsageInitialDelayMs(properties.getLocaleLicenseUsageCollectInitialDelayMs()).build();
    }

    public static class FakeTelemetryService
    implements TelemetryService {
        @Override
        public void startService() {
        }

        @Override
        public void registerLicenseUsageData(String product, boolean isSuccessCheck) {
        }
    }

    private static class FileAuditLogStorage
    implements AuditLogStorage {
        private final FileUserDataRepository userDataRepository;
        private final FileLicenseUsageRepository licenseUsageRepository;

        public FileAuditLogStorage(String sessionId, TelemetryFileHandler fileHandler, JsonChecksumCalculator checksumCalculator) {
            this.userDataRepository = new FileUserDataRepository(fileHandler, checksumCalculator);
            this.licenseUsageRepository = new FileLicenseUsageRepository(sessionId, fileHandler, checksumCalculator);
        }

        public LicenseUsageRepository licenseUsages() {
            return this.licenseUsageRepository;
        }

        public UserDataRepository userData() {
            return this.userDataRepository;
        }

        public String getName() {
            return this.getClass().getCanonicalName();
        }
    }
}

