/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

import chemaxon.common.util.DotfileUtil;
import chemaxon.license.TelemetryProperties;
import chemaxon.license.TelemetryPropertiesReader;
import chemaxon.license.TelemetryUtil;
import java.util.function.Supplier;

class TelemetryPropertiesProvider
implements TelemetryProperties {
    static final String AUDIT_FILE_NAME = "audit.log";
    static final int CLIENT_TIMEOUT_SEC = 10;
    static final int LICENSE_USAGE_COLLECT_PERIOD_MS = 300000;
    static final int LICENSE_USAGE_COLLECT_INITIAL_DELAY_MS = 100000;
    static final int LOCALE_USER_DATA_COLLECT_PERIOD_MS = 300000;
    static final int LOCALE_USER_DATA_COLLECT_INITIAL_DELAY_MS = 50000;
    static final int LOCALE_LICENSE_USAGE_COLLECT_PERIOD_MS = 300000;
    static final int LOCALE_LICENSE_USAGE_COLLECT_INITIAL_DELAY_MS = 150000;
    private static final int USER_DATA_REPOSITORY_GET_LIMIT = 5;
    private static final int LICENSE_USAGE_REPOSITORY_GET_LIMIT = 10;
    private final String sessionId;
    private final String auditFilePath;
    private final TelemetryPropertiesReader telemetryPropertiesReader;

    public static TelemetryPropertiesProvider of(TelemetryPropertiesReader telemetryPropertiesReader) {
        if (telemetryPropertiesReader == null) {
            throw new IllegalArgumentException("Telemetry properties reader can not be null.");
        }
        String sessionId = TelemetryUtil.getUUID();
        String auditFilePath = DotfileUtil.getDotDir().toString();
        return new TelemetryPropertiesProvider(sessionId, auditFilePath, telemetryPropertiesReader);
    }

    private TelemetryPropertiesProvider(String sessionId, String auditFilePath, TelemetryPropertiesReader telemetryPropertiesReader) {
        this.sessionId = sessionId;
        this.auditFilePath = auditFilePath;
        this.telemetryPropertiesReader = telemetryPropertiesReader;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public int getRemoteClientTimeoutSec() {
        return 10;
    }

    @Override
    public int getUserDataRepositoryGetLimit() {
        return 5;
    }

    @Override
    public int getLicenseUsageRepositoryGetLimit() {
        return 10;
    }

    @Override
    public int getLocaleUserDataCollectPeriodMs() {
        return 300000;
    }

    @Override
    public int getLocaleUserDataCollectInitialDelayMs() {
        return 50000;
    }

    @Override
    public String getAuditFilePath() {
        return this.auditFilePath;
    }

    @Override
    public String getAuditFileName() {
        return AUDIT_FILE_NAME;
    }

    @Override
    public int getLicenseUsageCollectPeriodMs() {
        return 300000;
    }

    @Override
    public int getLicenseUsageCollectInitialDelayMs() {
        return 100000;
    }

    @Override
    public int getLocaleLicenseUsageCollectPeriodMs() {
        return 300000;
    }

    @Override
    public int getLocaleLicenseUsageCollectInitialDelayMs() {
        return 150000;
    }

    @Override
    public String getServer() {
        return this.telemetryPropertiesReader.getServer();
    }

    @Override
    public boolean isTelemetryEnabled() {
        return this.telemetryPropertiesReader.isTelemetryEnabled();
    }

    @Override
    public Supplier<String> getLicenseKeyProvider() {
        return this.telemetryPropertiesReader.getLicenseKeyProvider();
    }
}

