/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

import chemaxon.license.HardwareDescriptor;
import chemaxon.license.SoftwareDescriptor;
import chemaxon.license.UserData;
import chemaxon.license.audit.LicenseCheckResult;
import chemaxon.license.audit.LicenseUsageEntry;
import chemaxon.license.audit.UserDataEntry;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.json.JSONObject;

class TelemetryJsonUtil {
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");

    private TelemetryJsonUtil() {
    }

    public static int getInt(String key, JSONObject object) {
        return TelemetryJsonUtil.getInt(key, object, -1);
    }

    public static int getInt(String key, JSONObject object, int defaultValue) {
        if (object.has(key)) {
            return (Integer)object.get(key);
        }
        return defaultValue;
    }

    public static String getString(String key, JSONObject object) {
        if (object.has(key)) {
            return (String)object.get(key);
        }
        return null;
    }

    public static LocalDateTime getLocalDateTime(String key, JSONObject object) {
        try {
            if (object.has(key)) {
                String dataString = (String)object.get(key);
                return LocalDateTime.parse(dataString.substring(0, 19), formatter);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Map<String, LicenseCheckResult> getCheckResultMap(String key, JSONObject object) {
        if (object.has(key)) {
            JSONObject licenseUsage = (JSONObject)object.get(key);
            return licenseUsage.toMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
                HashMap checkResult = (HashMap)e.getValue();
                return new LicenseCheckResult(0L, ((Integer)checkResult.get("success")).intValue(), ((Integer)checkResult.get("fail")).intValue());
            }));
        }
        return Map.of();
    }

    static JSONObject getJsonObject(LicenseUsageEntry licenseUsageEntry) {
        JSONObject object = new JSONObject();
        object.put("id", licenseUsageEntry.id());
        object.put("sessionId", (Object)licenseUsageEntry.sessionId());
        object.put("licenseKey", (Object)licenseUsageEntry.licenseKey());
        object.put("newHardwareId", (Object)licenseUsageEntry.newHardwareId());
        object.put("oldHardwareId", (Object)licenseUsageEntry.oldHardwareId());
        object.put("createdDate", (Object)formatter.format(licenseUsageEntry.createdDate()));
        JSONObject licenseUsageJson = new JSONObject();
        for (Map.Entry prod : licenseUsageEntry.licenseUsage().entrySet()) {
            JSONObject prodJson = new JSONObject();
            LicenseCheckResult result = (LicenseCheckResult)prod.getValue();
            prodJson.put("success", result.getSuccess());
            prodJson.put("fail", result.getFail());
            prodJson.put("id", result.getId());
            licenseUsageJson.put((String)prod.getKey(), (Object)prodJson);
        }
        object.put("licenseUsage", (Object)licenseUsageJson);
        return object;
    }

    static JSONObject getJsonObject(UserData userData) {
        JSONObject object = new JSONObject();
        object.put("userName", (Object)userData.getUserName());
        object.put("cxnHome", (Object)userData.getCxnHome());
        object.put("envVariable", (Object)userData.getEnvVariable());
        object.put("javaProperty", (Object)userData.getJavaProperty());
        object.put("serverUrlEnvVariable", (Object)userData.getServerUrlEnvVariable());
        object.put("licenseKeyEnvVariable", (Object)userData.getLicenseKeyEnvVariable());
        object.put("serverUrl", (Object)userData.getServerUrl());
        object.put("licenseKey", (Object)userData.getLicenseKey());
        object.put("licenseLogFile", (Object)userData.getLicenseLogFile());
        object.put("licenseFiles", userData.getLicenseFiles());
        JSONObject hardware = new JSONObject();
        HardwareDescriptor hardwareData = userData.getHardware();
        hardware.put("hardwareId", (Object)hardwareData.getHardwareId());
        hardware.put("oldHardwareId", (Object)hardwareData.getOldHardwareId());
        hardware.put("memoryId", (Object)hardwareData.getMemoryId());
        hardware.put("cpuId", (Object)hardwareData.getCpuId());
        hardware.put("vgaId", (Object)hardwareData.getVgaId());
        hardware.put("hardwareInformationProviderCls", (Object)hardwareData.getHardwareInformationProviderCls());
        object.put("hardware", (Object)hardware);
        object.put("hostName", (Object)userData.getHostName());
        JSONObject software = new JSONObject();
        SoftwareDescriptor softwareData = userData.getSoftware();
        software.put("vendor", (Object)softwareData.vendor());
        software.put("product", (Object)softwareData.product());
        software.put("mainClass", (Object)softwareData.mainClass());
        software.put("classPath", (Object)softwareData.classPath());
        object.put("software", (Object)software);
        object.put("cclVersion", (Object)userData.getCclVersion());
        return object;
    }

    static LicenseUsageEntry getLicenseUsages(JSONObject licenseUsageObject) {
        int id = TelemetryJsonUtil.getInt("id", licenseUsageObject);
        String sessionIdData = TelemetryJsonUtil.getString("sessionId", licenseUsageObject);
        String licenseKeyData = TelemetryJsonUtil.getString("licenseKey", licenseUsageObject);
        String oldHardwareId = TelemetryJsonUtil.getString("oldHardwareId", licenseUsageObject);
        String newHardwareId = TelemetryJsonUtil.getString("newHardwareId", licenseUsageObject);
        LocalDateTime createdDate = TelemetryJsonUtil.getLocalDateTime("createdDate", licenseUsageObject);
        Map<String, LicenseCheckResult> licenseUsageMap = TelemetryJsonUtil.getCheckResultMap("licenseUsage", licenseUsageObject);
        return new LicenseUsageEntry((long)id, sessionIdData, licenseKeyData, oldHardwareId, newHardwareId, createdDate, licenseUsageMap);
    }

    static UserDataEntry getUserData(JSONObject userData) {
        String sessionIdData = TelemetryJsonUtil.getString("sessionId", userData);
        String licenseKeyData = TelemetryJsonUtil.getString("licenseKey", userData);
        LocalDateTime createdDate = TelemetryJsonUtil.getLocalDateTime("createdDate", userData);
        return new UserDataEntry(sessionIdData, licenseKeyData, userData, createdDate);
    }
}

