/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

class TelemetryExecutors {
    private static final Logger telemetryLogger = Logger.getLogger("cxl.license.telemetry");
    private final int licenseUsagePeriodMs;
    private final int licenseUsageInitialDelayMs;
    private final int localeUserDataPeriodMs;
    private final int localeUserDataInitialDelayMs;
    private final int localeLicenseUsagePeriodMs;
    private final int localeLicenseUsageInitialDelayMs;
    private final ScheduledExecutorService schedulerExecutorService;
    private final Supplier<ExecutorService> executorServiceSupplier;
    private boolean started = false;
    private boolean addedShutdownHook = false;
    ScheduledFuture<?> localeUserDataCollecting;
    ScheduledFuture<?> localeLicenseUsageCollecting;

    private TelemetryExecutors(ScheduledExecutorService schedulerExecutorService, Supplier<ExecutorService> executorServiceSupplier, int licenseUsagePeriodMs, int licenseUsageInitialDelayMs, int localeUserDataPeriodMs, int localeUserDataInitialDelayMs, int localeLicenseUsagePeriodMs, int localeLicenseUsageInitialDelayMs) {
        this.licenseUsagePeriodMs = licenseUsagePeriodMs;
        this.licenseUsageInitialDelayMs = licenseUsageInitialDelayMs;
        this.executorServiceSupplier = executorServiceSupplier;
        this.schedulerExecutorService = schedulerExecutorService;
        this.localeUserDataPeriodMs = localeUserDataPeriodMs;
        this.localeUserDataInitialDelayMs = localeUserDataInitialDelayMs;
        this.localeLicenseUsagePeriodMs = localeLicenseUsagePeriodMs;
        this.localeLicenseUsageInitialDelayMs = localeLicenseUsageInitialDelayMs;
    }

    public void startScheduledExecutorService(Runnable userDataCollect, Runnable licenseUsageCollect, Runnable localeUserDataCollect, Runnable localeLicenseUsageCollect) {
        if (this.started) {
            return;
        }
        this.schedulerExecutorService.execute(userDataCollect);
        this.schedulerExecutorService.scheduleAtFixedRate(licenseUsageCollect, this.licenseUsageInitialDelayMs, this.licenseUsagePeriodMs, TimeUnit.MILLISECONDS);
        this.localeUserDataCollecting = localeUserDataCollect == null ? null : this.schedulerExecutorService.scheduleAtFixedRate(localeUserDataCollect, this.localeUserDataInitialDelayMs, this.localeUserDataPeriodMs, TimeUnit.MILLISECONDS);
        this.localeLicenseUsageCollecting = localeLicenseUsageCollect == null ? null : this.schedulerExecutorService.scheduleAtFixedRate(localeLicenseUsageCollect, this.localeLicenseUsageInitialDelayMs, this.localeLicenseUsagePeriodMs, TimeUnit.MILLISECONDS);
        this.started = true;
    }

    public void addShutDownHookTask(Runnable task) {
        if (this.addedShutdownHook) {
            return;
        }
        Runtime.getRuntime().addShutdownHook(new Thread(task));
        this.addedShutdownHook = true;
    }

    public void runTask(Runnable task) {
        ExecutorService executor = this.executorServiceSupplier.get();
        try {
            executor.execute(task);
            executor.shutdown();
        }
        catch (Exception e) {
            telemetryLogger.log(Level.SEVERE, e, () -> "Cannot execute telemetry data collecting in background.");
        }
    }

    public void cancelLocalUserDataCollecting() {
        if (this.localeUserDataCollecting != null) {
            this.localeUserDataCollecting.cancel(false);
        }
    }

    public void cancelLocalLicenseUsageCollecting() {
        if (this.localeUserDataCollecting != null) {
            this.localeUserDataCollecting.cancel(false);
        }
    }

    static class TelemetryExecutorsBuilder {
        private int licenseUsagePeriodMs;
        private int licenseUsageInitialDelayMs;
        private int localeUserDataPeriodMs;
        private int localeUserDataInitialDelayMs;
        private int localeLicenseUsagePeriodMs;
        private int localeLicenseUsageInitialDelayMs;
        private ScheduledExecutorService schedulerExecutorService;
        private Supplier<ExecutorService> executorServiceSupplier;

        TelemetryExecutorsBuilder() {
        }

        public TelemetryExecutorsBuilder setSchedulerExecutorService(ScheduledExecutorService schedulerExecutorService) {
            this.schedulerExecutorService = schedulerExecutorService;
            return this;
        }

        public TelemetryExecutorsBuilder setExecutorServiceSupplier(Supplier<ExecutorService> executorServiceSupplier) {
            this.executorServiceSupplier = executorServiceSupplier;
            return this;
        }

        public TelemetryExecutorsBuilder setLicenseUsagePeriodMs(int licenseUsagePeriodMs) {
            this.licenseUsagePeriodMs = licenseUsagePeriodMs;
            return this;
        }

        public TelemetryExecutorsBuilder setLicenseUsageInitialDelayMs(int licenseUsageInitialDelayMs) {
            this.licenseUsageInitialDelayMs = licenseUsageInitialDelayMs;
            return this;
        }

        public TelemetryExecutorsBuilder setLocaleUserDataPeriodMs(int localeUserDataPeriodMs) {
            this.localeUserDataPeriodMs = localeUserDataPeriodMs;
            return this;
        }

        public TelemetryExecutorsBuilder setLocaleUserDataInitialDelayMs(int localeUserDataInitialDelayMs) {
            this.localeUserDataInitialDelayMs = localeUserDataInitialDelayMs;
            return this;
        }

        public TelemetryExecutorsBuilder setLocaleLicenseUsagePeriodMs(int localeLicenseUsagePeriodMs) {
            this.localeLicenseUsagePeriodMs = localeLicenseUsagePeriodMs;
            return this;
        }

        public TelemetryExecutorsBuilder setLocaleLicenseUsageInitialDelayMs(int localeLicenseUsageInitialDelayMs) {
            this.localeLicenseUsageInitialDelayMs = localeLicenseUsageInitialDelayMs;
            return this;
        }

        public TelemetryExecutors build() {
            return new TelemetryExecutors(this.schedulerExecutorService, this.executorServiceSupplier, this.licenseUsagePeriodMs, this.licenseUsageInitialDelayMs, this.localeUserDataPeriodMs, this.localeUserDataInitialDelayMs, this.localeLicenseUsagePeriodMs, this.localeLicenseUsageInitialDelayMs);
        }
    }
}

