/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

import chemaxon.license.License;
import java.util.Arrays;
import java.util.stream.Collectors;

record SoftwareDescriptor(String vendor, String product, String mainClass, String classPath) {
    static final String UNKNOWN = "UNKNOWN";

    boolean isVendorSet() {
        return SoftwareDescriptor.isStringSet(this.vendor);
    }

    boolean isProductSet() {
        return SoftwareDescriptor.isStringSet(this.product);
    }

    boolean isMainClassSet() {
        return SoftwareDescriptor.isStringSet(this.mainClass);
    }

    boolean isClassPathSet() {
        return SoftwareDescriptor.isStringSet(this.classPath);
    }

    boolean accepts(License license) {
        return true;
    }

    static SoftwareDescriptor create(String vendor, String product) {
        return new SoftwareDescriptor(SoftwareDescriptor.valueOrUnknown(vendor), SoftwareDescriptor.valueOrUnknown(product), SoftwareDescriptor.valueOrUnknown(SoftwareDescriptor.getMainClass()), SoftwareDescriptor.valueOrUnknown(SoftwareDescriptor.collectClassPath()));
    }

    private static String valueOrUnknown(String value) {
        return SoftwareDescriptor.isStringSet(value) ? value.trim() : UNKNOWN;
    }

    private static String collectClassPath() {
        return SoftwareDescriptor.organizePath(System.getProperty("java.class.path"));
    }

    private static String getMainClass() {
        return System.getProperty("sun.java.command", "").split("\\s")[0];
    }

    private static boolean isStringSet(String value) {
        return value != null && !value.isBlank() && !UNKNOWN.equals(value);
    }

    static String organizePath(String cPath) {
        String[] parts = cPath.contains(";") ? cPath.split(";") : cPath.split(":");
        return Arrays.stream(parts).map(s -> s.contains("/") ? s.split("/") : s.split("\\\\")).map(array -> array[((String[])array).length - 1]).sorted().collect(Collectors.joining(","));
    }
}

