/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

import jakarta.xml.bind.DatatypeConverter;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Random;

final class SignatureVerifier {
    private static final String P = "178011905478542266528237562450159990145232156369120674273274450314442865788737020770612695252123463079567156784778466449970650770920727857050009668388144034129745221171818506047231150039301079959358067395348717066319802262019714966524135060945913707594956514672855690606794135837542707371727429551343320695239";
    private static final String Q = "864205495604807476120572616017955259175325408501";
    private static final String G = "174068207532402095185811980123523436538604490794561350978495831040599953488455823147851597408940950725307797094915759492368300574252438761037084473467180148876118103083043754985190983472601550494691329488083395492313850000361646482644608492304078721818959999056496097769368017749273708962006689187956744210730";
    private static final String Y = "151034596215571966609515966442420819724592846373870710038568444086347911148295876444754865919918743047523478389634420098941024951831146719082109987012839325503415015585712543422566979881271441136219141872768789086648612113835224816079801023563216089523436901749746992159562742512064613338663239720096194548432";
    private static PublicKey publicKey = null;
    private static final Random rnd = new SecureRandom();

    private SignatureVerifier() {
        throw new IllegalStateException("This class can not be instantiated");
    }

    private static void initPublicKey() throws InvalidKeySpecException, NoSuchAlgorithmException {
        BigInteger p = new BigInteger(P);
        BigInteger q = new BigInteger(Q);
        BigInteger g = new BigInteger(G);
        BigInteger y = new BigInteger(Y);
        DSAPublicKeySpec pubKS = new DSAPublicKeySpec(y, p, q, g);
        publicKey = KeyFactory.getInstance("DSA").generatePublic(pubKS);
    }

    static boolean verify(String sentData, String signature) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, InvalidKeySpecException {
        if (publicKey == null) {
            SignatureVerifier.initPublicKey();
        }
        Signature sig = Signature.getInstance("SHA1WithDSA");
        sig.initVerify(publicKey);
        sig.update(sentData.getBytes(StandardCharsets.UTF_8));
        byte[] sigBytes = DatatypeConverter.parseBase64Binary((String)signature);
        return sig.verify(sigBytes);
    }

    static String generateID() {
        return new BigInteger(1024, rnd).toString();
    }
}

