/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

import chemaxon.license.License;
import chemaxon.license.LicenseReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

record Ruleset(Map<String, List<ImplicationRule>> implications, Map<String, JChemSearchPerMin> jChemSearchPerMin) {
    Ruleset {
        implications = implications.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e -> List.copyOf((Collection)e.getValue())));
        jChemSearchPerMin = Map.copyOf(jChemSearchPerMin);
    }

    List<ImplicationRule> implications(String software) {
        return this.implications.getOrDefault(software, List.of());
    }

    void convert(License license, ImplicationConsumer consumer) {
        license.getSoftwareAndModules().forEach(software -> this.convert(license, (String)software, consumer));
    }

    private void convert(License license, String software, ImplicationConsumer consumer) {
        String integration = Ruleset.getIntegration(license);
        String edition = Ruleset.getEdition(license);
        consumer.accept(license, integration, software);
        JChemSearchPerMin searchPerMin = this.jChemSearchPerMin.get(software);
        if (searchPerMin != null) {
            LicenseReader licenseReader = LicenseReader.getInstance();
            licenseReader.setJChemSearchPerMin(switch (searchPerMin) {
                default -> throw new IncompatibleClassChangeError();
                case JChemSearchPerMin.AS_SPECIFIED_IN_LICENSE -> license.getRestriction("Search/Min");
                case JChemSearchPerMin.UNLIMITED -> "Unlimited";
            });
        }
        for (ImplicationRule rule : this.implications(software)) {
            if (!rule.correctEdition(edition)) continue;
            String env = rule.inEnvironment != null ? rule.inEnvironment : integration;
            for (String product : rule.implicates) {
                consumer.accept(license, env, product);
            }
        }
    }

    private static String getIntegration(License license) {
        String env = license.getRestriction("Integrated With");
        return env == null || env.isBlank() ? null : env;
    }

    private static String getEdition(License license) {
        String fieldValue = license.getRestriction("B/S/P/E");
        if (fieldValue == null && (fieldValue = license.getRestriction("B/S/P")) == null) {
            return "Unspecified Edition";
        }
        return fieldValue.trim();
    }

    @FunctionalInterface
    static interface ImplicationConsumer {
        public void accept(License var1, String var2, String var3);
    }

    static enum JChemSearchPerMin {
        AS_SPECIFIED_IN_LICENSE,
        UNLIMITED;

    }

    record ImplicationRule(String inEditions, String inEnvironment, List<String> implicates) {
        ImplicationRule {
            implicates = List.copyOf(implicates);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean correctEdition(String edition) {
            if (this.inEditions == null) return true;
            if (!Arrays.stream(this.inEditions.split(",")).anyMatch(edition::equalsIgnoreCase)) return false;
            return true;
        }
    }
}

