/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

import chemaxon.license.BaseRemoteClient;
import chemaxon.license.SimpleUriBuilder;
import chemaxon.license.TelemetryClient;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

class RemoteTelemetryClient
extends BaseRemoteClient
implements TelemetryClient {
    private static final Logger telemetryLogger = Logger.getLogger("cxl.license.telemetry");
    private static final String BASE_TELEMETRY_PATH = "/telemetry";
    private static final String USER_DATA_PATH = "/user-data";
    private static final String LICENSE_USAGE_PATH = "/license-usage";
    private static final String BULK_USER_DATA_PATH = "/bulk-user-data";
    private static final String BULK_LICENSE_USAGE_PATH = "/bulk-license-usage";
    private final String sessionId;

    RemoteTelemetryClient(String sessionId, String server, int clientTimeoutSec) {
        super(server, clientTimeoutSec);
        this.sessionId = sessionId;
    }

    @Override
    public RemoteTelemetryClientResult<String> sendUserData(JSONObject data) {
        return this.sendSingleData(data, USER_DATA_PATH);
    }

    @Override
    public RemoteTelemetryClientResult<String> sendLicenseUsage(JSONObject data) {
        return this.sendSingleData(data, LICENSE_USAGE_PATH);
    }

    private RemoteTelemetryClientResult<String> sendSingleData(JSONObject data, String path) {
        try {
            telemetryLogger.log(Level.FINER, () -> "Send to: " + path + " telemetry data: " + data.toString());
            HttpResponse<String> response = this.sendDataToServer(data, path, this.sessionId);
            if (response.statusCode() == 200) {
                telemetryLogger.log(Level.FINER, () -> "Successfully sent telemetry data to " + path + ", data: " + data.toString());
                return new RemoteTelemetryClientResult<String>(response.statusCode(), "");
            }
            telemetryLogger.log(Level.INFO, () -> "Cannot send telemetry data. Status code: " + response.statusCode());
            return new RemoteTelemetryClientResult<Object>(response.statusCode(), null);
        }
        catch (IOException ioe) {
            telemetryLogger.log(Level.INFO, ioe, () -> "Cannot send telemetry.");
            return new RemoteTelemetryClientResult<Object>(-1, null);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            telemetryLogger.log(Level.INFO, e, () -> "Sending telemetry data was interrupted.");
            return new RemoteTelemetryClientResult<Object>(-1, null);
        }
        catch (Exception e) {
            telemetryLogger.log(Level.INFO, e, () -> "Cannot send single telemetry data.");
            return new RemoteTelemetryClientResult<Object>(-1, null);
        }
    }

    private HttpResponse<String> sendDataToServer(JSONObject data, String path, String sessionId) throws IOException, InterruptedException {
        URI uri = this.getUri(BASE_TELEMETRY_PATH + path, sessionId);
        HttpRequest request = this.buildPostJsonRequest(uri, data);
        HttpClient client = this.createClient();
        return client.send(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
    }

    @Override
    public RemoteTelemetryClientResult<List<String>> sendBulkUserData(JSONObject data) {
        return this.sendBulkRequest(data, BULK_USER_DATA_PATH);
    }

    @Override
    public RemoteTelemetryClientResult<List<String>> sendBulkLicenseUsage(JSONObject data) {
        return this.sendBulkRequest(data, BULK_LICENSE_USAGE_PATH);
    }

    private RemoteTelemetryClientResult<List<String>> sendBulkRequest(JSONObject data, String path) {
        try {
            telemetryLogger.log(Level.FINER, () -> "Send to: " + path + " telemetry data: " + data.toString());
            HttpResponse<String> response = this.sendDataToServer(data, path, null);
            if (response.statusCode() == 200) {
                List<String> responseList = this.mapSessionIdsFromBody(response.body());
                return new RemoteTelemetryClientResult<List<String>>(response.statusCode(), responseList);
            }
            telemetryLogger.log(Level.INFO, () -> "Cannot send bulk telemetry data. Status code: " + response.statusCode());
            return new RemoteTelemetryClientResult<List<String>>(response.statusCode(), List.of());
        }
        catch (IOException ioe) {
            telemetryLogger.log(Level.INFO, ioe, () -> "Cannot send bulk telemetry data.");
            return new RemoteTelemetryClientResult<Object>(-1, null);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            telemetryLogger.log(Level.INFO, e, () -> "Sending bulk telemetry data was interrupted.");
            return new RemoteTelemetryClientResult<Object>(-1, null);
        }
        catch (Exception e) {
            telemetryLogger.log(Level.INFO, e, () -> "Cannot send bulk telemetry.");
            return new RemoteTelemetryClientResult<Object>(-1, null);
        }
    }

    private URI getUri(String endpoint, String sessionId) {
        try {
            SimpleUriBuilder uriBuilder = new SimpleUriBuilder(this.server).setPath(endpoint);
            if (sessionId != null) {
                uriBuilder.addParameter("sessionId", sessionId);
            }
            return uriBuilder.build();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new IllegalArgumentException("Invalid arguments. Can not build URI with endpoint: " + endpoint + " , sessionId: " + sessionId);
        }
    }

    private List<String> mapSessionIdsFromBody(String body) {
        if (body == null || body.isBlank() || body.isEmpty()) {
            return List.of();
        }
        return new JSONArray(body).toList().stream().map(x -> (String)x).toList();
    }

    private HttpRequest buildPostJsonRequest(URI uri, JSONObject postObject) {
        return HttpRequest.newBuilder().uri(uri).setHeader("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(postObject.toString(), StandardCharsets.UTF_8)).build();
    }

    public static class RemoteTelemetryClientResult<T> {
        private final int statusCode;
        private final T responseObject;

        public RemoteTelemetryClientResult(int statusCode, T responseObject) {
            this.statusCode = statusCode;
            this.responseObject = responseObject;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public T getResponseObject() {
            return this.responseObject;
        }
    }
}

