/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

import chemaxon.common.util.DotfileUtil;
import chemaxon.common.util.StringTools;
import chemaxon.license.License;
import chemaxon.license.LicenseManagerProperties;
import chemaxon.license.RemoteLicenseClient;
import chemaxon.license.RemoteLicenseReader;
import chemaxon.license.SoftwareDescriptor;
import chemaxon.license.XMLVerifier;
import chemaxon.license.XMLWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

class RemoteLicenseReaderImpl
implements RemoteLicenseReader {
    private static final Logger logger = Logger.getLogger("cxl.license.telemetry");
    static final String LICENSE_CACHE = "remote-license.xml";
    private final LicenseManagerProperties properties;
    private final Set<License> availableLicenses = Collections.synchronizedSet(new HashSet());
    private Optional<SoftwareDescriptor> contextFilter = Optional.empty();
    private RemoteLicenseClient client;

    RemoteLicenseReaderImpl() {
        this.properties = LicenseManagerProperties.getInstance();
        this.client = new RemoteLicenseClient(this.properties.getServer());
    }

    private List<License> getFallbackLicense() {
        File f = new File(DotfileUtil.getDotDir(), LICENSE_CACHE);
        if (f.exists()) {
            List<License> list;
            FileInputStream is = new FileInputStream(f);
            try {
                list = this.readLicense(is);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    logger.log(Level.INFO, "Failed to read locally cached license file", e);
                }
            }
            ((InputStream)is).close();
            return list;
        }
        return new LinkedList<License>();
    }

    private void persistLicense(List<License> licenses) {
        File f = new File(DotfileUtil.getDotDir(), LICENSE_CACHE);
        try (FileOutputStream os = new FileOutputStream(f);){
            new XMLWriter().writeXML(licenses, os);
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Failed to write license cache", e);
        }
    }

    private List<License> readLicense(InputStream is) {
        try {
            XMLVerifier verify = new XMLVerifier();
            List<License> licenses = verify.verifyXML(is).stream().filter(this::isLicenseValidInContext).peek(this.availableLicenses::add).toList();
            return new ArrayList<License>(licenses);
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Failed to read license file", e);
            return Collections.emptyList();
        }
    }

    public void setClient(RemoteLicenseClient client) {
        this.client = client;
    }

    private List<License> convertToLicenses(String xml) {
        try {
            XMLVerifier verify = new XMLVerifier();
            ByteArrayInputStream input = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
            List<License> licenses = verify.verifyXML(input).stream().filter(this::isLicenseValidInContext).peek(this.availableLicenses::add).toList();
            return new ArrayList<License>(licenses);
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Failed to read license file", e);
            return Collections.emptyList();
        }
    }

    private List<License> downloadRemoteLicenses() {
        try {
            List<License> licenses;
            String remoteLicensesXml = this.client.getAvailableLicenses(this.properties.getLicenseKey());
            List<License> list = licenses = remoteLicensesXml.isBlank() ? List.of() : this.convertToLicenses(remoteLicensesXml);
            if (!licenses.isEmpty()) {
                this.availableLicenses.addAll(licenses);
                this.persistLicense(licenses);
                return licenses;
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, e, () -> "Failed to retrieve license file from server: " + this.properties.getServer());
        }
        return this.getFallbackLicense();
    }

    @Override
    public List<License> getAvailableLicenses() {
        boolean licenseKeyDefined = !StringTools.isBlank((String)this.properties.getLicenseKey());
        return licenseKeyDefined ? this.downloadRemoteLicenses() : new ArrayList<License>(this.availableLicenses);
    }

    @Override
    public RemoteLicenseReader getWrappedRemoteLicenseReader() {
        return null;
    }

    @Override
    public void setLicenseContext(SoftwareDescriptor softwareDescriptor) {
        this.contextFilter = Optional.ofNullable(softwareDescriptor);
        if (!StringTools.isBlank((String)this.properties.getLicenseKey())) {
            this.availableLicenses.clear();
        }
    }

    private boolean isLicenseValidInContext(License license) {
        return this.contextFilter.map(sd -> sd.accepts(license)).orElse(true);
    }
}

