/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

import chemaxon.license.BaseRemoteClient;
import chemaxon.license.SimpleUriBuilder;
import chemaxon.license.TelemetryUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RemoteLicenseClient
extends BaseRemoteClient {
    private static final String LICENSE_KEY_PARAM_NAME = "licenseKey";
    private static final Logger installLogger = Logger.getLogger("cxl.license.install");
    private static final String GET_AVAILABLE_LICENSES_PATH = "/api/v2313/licenses";
    private static final int DEFAULT_CLIENT_TIMEOUT_SEC = 10;

    public RemoteLicenseClient(String server) {
        super(server, 10);
    }

    String getAvailableLicenses(String licenseKey) throws MalformedURLException, URISyntaxException {
        try {
            if (licenseKey == null) {
                installLogger.log(Level.INFO, "Cannot get available licenses from remote server because license key is null!");
                return "";
            }
            URI uri = new SimpleUriBuilder(this.server).setPath(GET_AVAILABLE_LICENSES_PATH).addParameter(LICENSE_KEY_PARAM_NAME, licenseKey).addParameter("hardwareId", TelemetryUtil.getHardwareIdV2()).build();
            HttpRequest request = this.buildGetXmlRequest(uri);
            HttpClient client = this.createClient();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
            if (response.statusCode() == 200) {
                return response.body();
            }
            installLogger.log(Level.INFO, () -> "Failed to retrieve available licenses from the server: " + this.server + " Status code: " + response.statusCode());
            return "";
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new IllegalStateException("Badly configured uri, Cannot get available licenses from server.");
        }
        catch (IOException e) {
            installLogger.log(Level.INFO, e, () -> "Failed to retrieve available licenses from the server: " + this.server);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            installLogger.log(Level.INFO, e, () -> "Get available licenses from remote server wa interrupted.");
        }
        return "";
    }

    public void checkConnection(String licenseKey) {
        try {
            URI uri = new SimpleUriBuilder(this.server).setPath("/check").addParameter(LICENSE_KEY_PARAM_NAME, licenseKey).build();
            HttpRequest request = this.buildGetXmlRequest(uri);
            HttpClient client = this.createClient();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
            if (response.statusCode() != 200) {
                throw new RuntimeException("Connection failed. Server: " + this.server + " Status code: " + response.statusCode());
            }
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new IllegalStateException("Badly configured uri, Cannot check connection.");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            installLogger.log(Level.INFO, e, () -> "Checking connection with server was interrupted");
        }
        catch (IOException e) {
            installLogger.log(Level.INFO, "Communication error occurred during the connection checking.", e);
            throw new IllegalArgumentException("Connection failed. Please check your license URL.");
        }
    }

    private HttpRequest buildGetXmlRequest(URI uri) {
        return HttpRequest.newBuilder().uri(uri).setHeader("Content-Type", "application/xml").GET().build();
    }
}

