/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

import chemaxon.license.RemoteTelemetryClient;
import chemaxon.license.TelemetryClient;
import chemaxon.license.TelemetryExecutors;
import chemaxon.license.TelemetryJsonUtil;
import chemaxon.license.TelemetryService;
import chemaxon.license.TelemetryUtil;
import chemaxon.license.UserData;
import chemaxon.license.audit.AuditLogEntry;
import chemaxon.license.audit.AuditLogStorage;
import chemaxon.license.audit.LicenseCheckResult;
import chemaxon.license.audit.LicenseUsageEntry;
import chemaxon.license.audit.LicenseUsageRepository;
import chemaxon.license.audit.UserDataEntry;
import chemaxon.license.audit.UserDataRepository;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

class OnlineTelemetryService
implements TelemetryService {
    static Logger logger = Logger.getLogger("cxl.license.telemetry");
    private boolean started = false;
    private final String sessionId;
    private final Supplier<String> licenseKeySupplier;
    private final TelemetryClient client;
    private final TelemetryExecutors executors;
    private final int userDataRepositoryGetLimit;
    private final int licenseUsageRepositoryGetLimit;
    private final UserDataRepository userDataRepository;
    private final LicenseUsageRepository licenseUsageRepository;
    private Map<String, LicenseCheckResult> licenseUsage;
    static AtomicInteger exceptionCount = new AtomicInteger();

    OnlineTelemetryService(Supplier<String> licenseKeySupplier, String sessionId, TelemetryClient client, int userDataRepositoryGetLimit, int licenseUsageRepositoryGetLimit, AuditLogStorage repositories, TelemetryExecutors executors) {
        this.sessionId = sessionId;
        this.licenseKeySupplier = licenseKeySupplier;
        this.client = client;
        this.executors = executors;
        this.userDataRepositoryGetLimit = userDataRepositoryGetLimit;
        this.licenseUsageRepositoryGetLimit = licenseUsageRepositoryGetLimit;
        this.userDataRepository = repositories.userData();
        this.licenseUsageRepository = repositories.licenseUsages();
        this.licenseUsage = new HashMap<String, LicenseCheckResult>();
    }

    void collectUserData() {
        Runnable task = () -> {
            UserData userData = UserData.collect();
            if (this.licenseKeySupplier != null && this.licenseKeySupplier.get() != null && this.trySendUserDataToRemote(userData)) {
                return;
            }
            this.tryStoreUserData(userData);
        };
        this.executors.runTask(task);
    }

    private boolean trySendUserDataToRemote(UserData userData) {
        RemoteTelemetryClient.RemoteTelemetryClientResult<String> result = this.client.sendUserData(TelemetryJsonUtil.getJsonObject(userData));
        return result.getStatusCode() == 200;
    }

    private void tryStoreUserData(UserData userData) {
        try {
            this.userDataRepository.save((AuditLogEntry)this.mapUserData(userData));
        }
        catch (Exception exception) {
            exceptionCount.incrementAndGet();
            logger.log(Level.INFO, exception, () -> "Can not send user data to remote server and fall back process can not handle too.");
        }
    }

    void collectLocaleUserData() {
        Runnable task = () -> {
            List<UserDataEntry> userDataList = this.getOlderSessionsUserData();
            if (!userDataList.isEmpty()) {
                RemoteTelemetryClient.RemoteTelemetryClientResult<List<String>> result = this.trySendBulkUserDataToRemote(userDataList);
                this.tryClearLocaleUserData(result);
            } else {
                this.executors.cancelLocalUserDataCollecting();
            }
        };
        this.executors.runTask(task);
    }

    private RemoteTelemetryClient.RemoteTelemetryClientResult<List<String>> trySendBulkUserDataToRemote(List<UserDataEntry> userDataList) {
        JSONObject data = this.createCollectableFromLocalUserData(userDataList);
        return this.client.sendBulkUserData(data);
    }

    private void tryClearLocaleUserData(RemoteTelemetryClient.RemoteTelemetryClientResult<List<String>> result) {
        if (result.getStatusCode() == 200) {
            try {
                this.userDataRepository.deleteMany((Iterable)result.getResponseObject());
            }
            catch (Exception exception) {
                exceptionCount.incrementAndGet();
                logger.log(Level.INFO, exception, () -> "Can not clear user data from locale store.");
            }
        }
    }

    private List<UserDataEntry> getOlderSessionsUserData() {
        try {
            Iterable userData = this.userDataRepository.getOldestEntriesWithLicenseKey(this.userDataRepositoryGetLimit);
            ArrayList userDataList = new ArrayList();
            if (userData != null) {
                userData.forEach(userDataList::add);
            }
            return userDataList.stream().filter(x -> !Objects.equals(x.sessionId(), this.sessionId)).toList();
        }
        catch (Exception exception) {
            exceptionCount.incrementAndGet();
            logger.log(Level.INFO, exception, () -> "Unable to get user data.");
            return List.of();
        }
    }

    private JSONObject createCollectableFromLocalUserData(List<UserDataEntry> userDataList) {
        JSONArray arrayList = new JSONArray();
        userDataList.stream().map(y -> {
            JSONObject tempUserData = y.userData();
            tempUserData.put("createdDate", (Object)y.createdDate());
            tempUserData.put("sessionId", (Object)y.sessionId());
            return tempUserData;
        }).forEach(arg_0 -> ((JSONArray)arrayList).put(arg_0));
        JSONObject object = new JSONObject();
        object.put("userData", (Object)arrayList);
        return object;
    }

    void collectLicenseUsageData() {
        if (!this.licenseUsage.isEmpty()) {
            Runnable task = () -> {
                Map<String, LicenseCheckResult> lastChunkLicenseUsage = this.collectLastChunkOfLicenseUsage();
                LicenseUsageEntry licenseUsageData = new LicenseUsageEntry(this.sessionId, this.licenseKeySupplier.get(), TelemetryUtil.getHardwareIdV1(), TelemetryUtil.getHardwareIdV2(), LocalDateTime.now(), lastChunkLicenseUsage);
                if (this.licenseKeySupplier.get() != null && this.trySendLicenseUsageToRemote(licenseUsageData)) {
                    return;
                }
                this.tryStoreLicenseUsage(licenseUsageData);
            };
            this.executors.runTask(task);
        }
    }

    synchronized Map<String, LicenseCheckResult> collectLastChunkOfLicenseUsage() {
        Map<String, LicenseCheckResult> tempMap = this.licenseUsage;
        this.licenseUsage = new HashMap<String, LicenseCheckResult>();
        return tempMap;
    }

    private boolean trySendLicenseUsageToRemote(LicenseUsageEntry licenseUsageData) {
        RemoteTelemetryClient.RemoteTelemetryClientResult<String> result = this.client.sendLicenseUsage(TelemetryJsonUtil.getJsonObject(licenseUsageData));
        return result.getStatusCode() == 200;
    }

    private void tryStoreLicenseUsage(LicenseUsageEntry licenseUsageData) {
        try {
            this.licenseUsageRepository.save((AuditLogEntry)licenseUsageData);
        }
        catch (Exception exception) {
            exceptionCount.incrementAndGet();
            logger.log(Level.INFO, exception, () -> "Can not send license usage to remote server and fall back process can not handle too.");
            logger.log(Level.INFO, () -> "LicenseUsageData: " + licenseUsageData);
        }
    }

    void collectLocaleLicenseUsage() {
        Runnable task = () -> {
            List<LicenseUsageEntry> licenseUsageDataList = this.getOlderSessionsLicenseUsage();
            if (!licenseUsageDataList.isEmpty()) {
                RemoteTelemetryClient.RemoteTelemetryClientResult<List<String>> result = this.trySendBulkLicenseUsageToRemote(licenseUsageDataList);
                this.tryClearLocaleLicenseUsage(result);
            } else {
                this.executors.cancelLocalLicenseUsageCollecting();
            }
        };
        this.executors.runTask(task);
    }

    private RemoteTelemetryClient.RemoteTelemetryClientResult<List<String>> trySendBulkLicenseUsageToRemote(List<LicenseUsageEntry> data) {
        JSONObject object = new JSONObject();
        JSONArray licenseUsageArray = new JSONArray();
        licenseUsageArray.putAll(data.stream().map(TelemetryJsonUtil::getJsonObject).toList());
        object.put("licenseUsage", (Object)licenseUsageArray);
        return this.client.sendBulkLicenseUsage(object);
    }

    private void tryClearLocaleLicenseUsage(RemoteTelemetryClient.RemoteTelemetryClientResult<List<String>> result) {
        if (result.getStatusCode() == 200) {
            try {
                this.licenseUsageRepository.deleteMany((Iterable)result.getResponseObject());
            }
            catch (Exception exception) {
                exceptionCount.incrementAndGet();
                logger.log(Level.INFO, exception, () -> "Can not delete user data from locale store.");
            }
        }
    }

    private List<LicenseUsageEntry> getOlderSessionsLicenseUsage() {
        try {
            Iterable licenseUsageDataIterable = this.licenseUsageRepository.getOldestEntriesWithLicenseKey(this.licenseUsageRepositoryGetLimit);
            ArrayList licenseUsageDataList = new ArrayList();
            licenseUsageDataIterable.forEach(licenseUsageDataList::add);
            return licenseUsageDataList.stream().filter(x -> !Objects.equals(x.sessionId(), this.sessionId)).toList();
        }
        catch (Exception exception) {
            exceptionCount.incrementAndGet();
            logger.log(Level.INFO, exception, () -> "Unable to get license usage data.");
            return List.of();
        }
    }

    private UserDataEntry mapUserData(UserData userData) {
        return new UserDataEntry(this.sessionId, userData.getLicenseKey(), TelemetryJsonUtil.getJsonObject(userData), LocalDateTime.now());
    }

    @Override
    public synchronized void startService() {
        if (!this.started) {
            if (this.licenseKeySupplier.get() != null) {
                this.executors.startScheduledExecutorService(this::collectUserData, this::collectLicenseUsageData, this::collectLocaleUserData, this::collectLocaleLicenseUsage);
            } else {
                this.executors.startScheduledExecutorService(this::collectUserData, this::collectLicenseUsageData, null, null);
            }
            this.executors.addShutDownHookTask(this::collectLicenseUsageData);
        }
        this.started = true;
    }

    @Override
    public synchronized void registerLicenseUsageData(String product, boolean isSuccessCheck) {
        if (!this.started) {
            this.startService();
        }
        this.licenseUsage.putIfAbsent(product, new LicenseCheckResult());
        if (isSuccessCheck) {
            this.licenseUsage.get(product).registerSuccess();
        } else {
            this.licenseUsage.get(product).registerFail();
        }
    }
}

