/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

import chemaxon.license.LicenseHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class LicenseThread
extends Thread {
    private static final AtomicLong ALONG = new AtomicLong(0L);
    private final List<String> callStack;
    private final Set<String> callStackSet;

    public LicenseThread() {
        this((Runnable)null);
    }

    public LicenseThread(Runnable target) {
        this(target, LicenseThread.getLicenseThreadName());
    }

    public LicenseThread(Runnable target, String name) {
        this(null, target, name);
    }

    public LicenseThread(ThreadGroup threadGroup, Runnable runnable) {
        this(threadGroup, runnable, LicenseThread.getLicenseThreadName());
    }

    public LicenseThread(ThreadGroup threadGroup, Runnable runnable, String name) {
        this(threadGroup, runnable, name, 0L);
    }

    public LicenseThread(ThreadGroup threadGroup, String name) {
        this(threadGroup, null, name, 0L);
    }

    public LicenseThread(ThreadGroup threadGroup, Runnable runnable, String name, long stacksize) {
        super(threadGroup, runnable, name, stacksize);
        ArrayList<String> collector = new ArrayList<String>(LicenseHandler.getInstance().getCallStackList());
        Thread thread = Thread.currentThread();
        if (thread instanceof LicenseThread) {
            LicenseThread licThread = (LicenseThread)thread;
            collector.addAll(licThread.getCallStackList());
        }
        this.callStack = Collections.unmodifiableList(collector);
        this.callStackSet = Collections.unmodifiableSet(new HashSet<String>(this.callStack));
    }

    List<String> getCallStackList() {
        return this.callStack;
    }

    Set<String> getCallStackSet() {
        return this.callStackSet;
    }

    private static String getLicenseThreadName() {
        return "cxn-lt-" + ALONG.incrementAndGet();
    }
}

