/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

import chemaxon.common.util.DotfileUtil;
import chemaxon.license.LicenseReportUserData;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class LicenseReportUserDataWriter {
    private static final Logger generalLogger = Logger.getLogger("cxl.license.general");
    private final LicenseReportUserData reportUserData = new LicenseReportUserData();
    private static final String ZIP_FILE_NAME = "licenseData.zip";
    private static final String PROPERTY_FILE_NAME = "licenseProperties.txt";
    private String targetDirectory = DotfileUtil.getDotDir().getAbsolutePath();
    private String dataFileName = this.targetDirectory + File.separator + "licenseData.zip";
    private String licPropertiesFile = this.targetDirectory + File.separator + "licenseProperties.txt";

    public void setTargetDirectory(String targetDirectory) {
        this.targetDirectory = targetDirectory;
        this.dataFileName = targetDirectory + File.separator + ZIP_FILE_NAME;
        this.licPropertiesFile = targetDirectory + File.separator + PROPERTY_FILE_NAME;
    }

    public String getTargetDirectory() {
        return this.targetDirectory;
    }

    public String getZipFileName() {
        return ZIP_FILE_NAME;
    }

    public void generateReportFile() throws IOException {
        File logFile = this.reportUserData.getUserData().getLicenseLogFile();
        List<String> filesToWrite = this.reportUserData.getUserData().getLicenseFiles();
        File propertyFile = this.createPropertyFile(filesToWrite, logFile);
        if (logFile != null) {
            filesToWrite.add(logFile.getAbsolutePath());
        }
        filesToWrite.add(propertyFile.getAbsolutePath());
        this.writeFilesToZipFile(filesToWrite);
        propertyFile.delete();
    }

    private void writeFilesToZipFile(List<String> filesToWrite) throws IOException {
        FileOutputStream fos = new FileOutputStream(this.dataFileName);
        ZipOutputStream zos = new ZipOutputStream(fos);
        Map<String, String> files = this.readFiles(filesToWrite);
        for (Map.Entry<String, String> e : files.entrySet()) {
            this.addToZip(zos, new ByteArrayInputStream(e.getValue().getBytes(StandardCharsets.UTF_8)), e.getKey());
        }
        zos.close();
    }

    private void addToZip(ZipOutputStream zos, InputStream in, String name) throws IOException {
        int length;
        zos.putNextEntry(new ZipEntry(name));
        byte[] buffer = new byte[1024];
        while ((length = in.read(buffer)) > 0) {
            zos.write(buffer, 0, length);
        }
        zos.closeEntry();
    }

    private Map<String, String> readFiles(List<String> files) {
        HashMap<String, String> map = new HashMap<String, String>(files.size());
        for (String path : files) {
            InputStream fin = null;
            StringBuilder fileContentOrError = new StringBuilder();
            try {
                try {
                    URL u = new URL(path);
                    fin = u.openConnection().getInputStream();
                }
                catch (MalformedURLException mfe) {
                    try {
                        fin = new FileInputStream(path);
                    }
                    catch (FileNotFoundException nfe) {
                        fileContentOrError.append("File not found: ").append(nfe.getMessage());
                        generalLogger.log(Level.INFO, nfe, () -> "File not found.");
                    }
                }
                if (fin != null) {
                    String line;
                    BufferedReader br = new BufferedReader(new InputStreamReader(fin, StandardCharsets.UTF_8));
                    while ((line = br.readLine()) != null) {
                        fileContentOrError.append(line).append("\n");
                    }
                    fin.close();
                }
            }
            catch (SecurityException sex) {
                fileContentOrError.append("Can't read file because of permission problems: ").append(sex.getMessage());
                generalLogger.log(Level.INFO, sex, () -> "Can't read file because of permission problems.");
            }
            catch (IOException e) {
                fileContentOrError.append("Can't read file: ").append(e.getMessage());
                generalLogger.log(Level.INFO, e, () -> "Can't read file.");
            }
            map.put(path.replaceAll("[^a-zA-Z0-9_.]", "-"), fileContentOrError.toString());
        }
        return map;
    }

    private File createPropertyFile(List<String> filesToWrite, File logFile) throws IOException {
        File propertyFile = new File(this.licPropertiesFile);
        propertyFile.deleteOnExit();
        FileWriter writer = new FileWriter(propertyFile);
        writer.write(this.reportUserData.toString());
        if (filesToWrite.isEmpty()) {
            writer.write("License file was not found\n");
        }
        if (logFile == null) {
            writer.write("Logfile was not found\n");
        }
        ((Writer)writer).close();
        return propertyFile;
    }
}

