/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

import chemaxon.common.util.BasicEnvironment;
import chemaxon.license.TelemetryUtil;
import chemaxon.license.UserData;
import com.chemaxon.version.VersionInfo;
import java.util.List;
import java.util.Locale;

public class LicenseReportUserData {
    private final UserData userData = UserData.collect();

    public UserData getUserData() {
        return this.userData;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Chemaxon version number:    ").append(VersionInfo.getDisplayVersion()).append("\n");
        sb.append("Internal version number:    ").append(VersionInfo.getInternalVersionId()).append("\n");
        sb.append("Build date:                 ").append(VersionInfo.getBuildDate()).append("\n");
        sb.append("Operating system:           ").append(BasicEnvironment.getOperatingSystemInfo()).append("\n");
        sb.append("Java:                       ").append(BasicEnvironment.getJavaInfo()).append("\n");
        sb.append("JVM:                        ").append(BasicEnvironment.getJvmInfo()).append("\n");
        sb.append("Locale, encoding:           ").append(Locale.getDefault().toString()).append(", ").append(BasicEnvironment.getEncodingInfo()).append("\n");
        sb.append("\n");
        sb.append("User name:                  ").append(this.userData.getUserName()).append("\n");
        sb.append("Chemaxon home:              ").append(this.userData.getCxnHome()).append("\n");
        sb.append("Server URL:                 ").append(this.userData.getServerUrl()).append("\n");
        sb.append("License key:                ").append(this.userData.getLicenseKey()).append("\n");
        sb.append("Java property:              ").append(this.userData.getJavaProperty()).append("\n");
        sb.append("Env. variable:              ").append(this.userData.getEnvVariable()).append("\n");
        sb.append("Server URL env. variable:   ").append(this.userData.getServerUrlEnvVariable()).append("\n");
        sb.append("License key env. variable:  ").append(this.userData.getLicenseKeyEnvVariable()).append("\n");
        sb.append("\n");
        sb.append("License files:              ");
        List<String> licenseFiles = this.userData.getLicenseFiles();
        for (int i = 0; i < licenseFiles.size(); ++i) {
            if (i > 0) {
                sb.append("                            ");
            }
            sb.append(licenseFiles.get(i)).append("\n");
        }
        if (licenseFiles.isEmpty()) {
            sb.append("\n");
        }
        sb.append("License log file:           ").append(this.userData.getLicenseLogFile().getAbsolutePath()).append("\n");
        sb.append("\n");
        sb.append("Product:                    ").append(this.userData.getSoftware().product()).append("\n");
        sb.append("Vendor:                     ").append(this.userData.getSoftware().vendor()).append("\n");
        sb.append("Main Class:                 ").append(this.userData.getSoftware().mainClass()).append("\n");
        sb.append("Class Path files:           ").append(this.userData.getSoftware().classPath()).append("\n");
        sb.append("\n");
        sb.append("Host Name:                  ").append(this.userData.getHostName()).append("\n");
        sb.append("Old HardwareID:             ").append("\n").append(TelemetryUtil.getHardwareIdV1()).append("\n");
        sb.append("New HardwareID:             ").append("\n").append(this.userData.getHardware().getHardwareId()).append("\n");
        return sb.toString();
    }
}

