/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

import chemaxon.common.util.DotfileUtil;
import chemaxon.license.FakeRemoteLicenseReader;
import chemaxon.license.License;
import chemaxon.license.LicenseExceptionHandler;
import chemaxon.license.LicenseHandler;
import chemaxon.license.LicenseManagerProperties;
import chemaxon.license.LicenseProcessingException;
import chemaxon.license.RemoteLicenseReader;
import chemaxon.license.RemoteLicenseReaderImpl;
import chemaxon.license.Resettable;
import chemaxon.license.SoftwareDescriptor;
import chemaxon.license.ThrottlingRemoteLicenseReader;
import chemaxon.license.XMLVerifier;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class LicenseReader {
    public static final String ENVIRONMENT_VARIABLE_PATH = "CHEMAXON_LICENSE_URL";
    public static final String JAVA_PROPERTY_PATH = "chemaxon.license.url";
    public static final String LICENSE_FILE_EXTENSION = "cxl";
    private static final Set<LicenseFileContent> cxlFileContents = new HashSet<LicenseFileContent>();
    static final String DEFAULT_LICENSE_FILE = "license.cxl";
    static final String DEFAULT_LICENSE_DIRECTORY = "licenses";
    private static final List<License> licenses = new ArrayList<License>();
    private static XMLVerifier verifier = null;
    private static String lastLicensePath = "";
    private static final List<String> licensePaths = new ArrayList<String>();
    private static int maximumSearchPerMin = 0;
    private static Logger installLogger = null;
    private static final String DEFAULT = "default";
    private static final RemoteLicenseReader VALID_REMOTE_LICENSE_READER = LicenseReader.createRemoteLicenseReaderWithThrottling();
    private static final RemoteLicenseReader FAKE_REMOTE_LICENSE_READER = new FakeRemoteLicenseReader();
    private RemoteLicenseReader remoteLicenseReader;
    private Optional<SoftwareDescriptor> licenseContextFilter = Optional.empty();

    LicenseReader() {
        this.remoteLicenseReader = VALID_REMOTE_LICENSE_READER;
        this.remoteLicenseReader.setLicenseContext(this.licenseContextFilter.orElse(null));
    }

    private static RemoteLicenseReader createRemoteLicenseReaderWithThrottling() {
        return new ThrottlingRemoteLicenseReader(new RemoteLicenseReaderImpl());
    }

    public RemoteLicenseReader getRemoteLicenseReader() {
        return this.remoteLicenseReader;
    }

    public static LicenseReader getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void setLoggers(Logger il) {
        installLogger = il;
    }

    public void clear() {
        licenses.clear();
        cxlFileContents.clear();
        LicenseExceptionHandler.getInstance().clearCache();
        this.remoteLicenseReader = VALID_REMOTE_LICENSE_READER;
        this.resetRemoteLicenseReader();
        maximumSearchPerMin = 0;
    }

    private void resetRemoteLicenseReader() {
        RemoteLicenseReader remoteLicenseReader = this.remoteLicenseReader;
        if (remoteLicenseReader instanceof Resettable) {
            Resettable r = (Resettable)((Object)remoteLicenseReader);
            r.reset();
        }
    }

    public void read() {
        this.readSystemProperty();
        this.readEnvironmentVariable();
        this.readBuiltIn();
        this.readUserHome();
    }

    void setLicenseContextFilterInformation(SoftwareDescriptor contextFilter) {
        this.licenseContextFilter = Optional.ofNullable(contextFilter);
        this.remoteLicenseReader.setLicenseContext(contextFilter);
    }

    public void fetch() throws LicenseProcessingException {
        LicenseProcessingException exception = null;
        for (LicenseFileContent license : cxlFileContents) {
            try {
                this.verifyCXLContents(license, licenses);
            }
            catch (LicenseProcessingException lpe) {
                exception = lpe;
            }
        }
        if (exception != null) {
            throw exception;
        }
        this.fetchRemoteLicenses();
    }

    private void fetchRemoteLicenses() {
        if (this.remoteLicenseReader != null) {
            this.remoteLicenseReader.getAvailableLicenses().stream().filter(lic -> !licenses.contains(lic)).forEach(licenses::add);
        }
    }

    public synchronized int getJChemSearchPerMin() {
        return maximumSearchPerMin;
    }

    synchronized void setJChemSearchPerMin(String spm) {
        if ("Unlimited".equals(spm)) {
            maximumSearchPerMin = Integer.MAX_VALUE;
        } else {
            try {
                int s = Integer.parseInt(spm);
                if (s > maximumSearchPerMin) {
                    maximumSearchPerMin = s;
                }
            }
            catch (NumberFormatException nfe) {
                installLogger.log(Level.FINE, nfe, () -> "Problem during setting JChem search per min.");
            }
        }
    }

    public synchronized void setLicense(String s) {
        cxlFileContents.add(new LicenseFileContent(s, true, null));
    }

    synchronized void setLicenseFile(String licensePath) throws LicenseProcessingException {
        this.setLastLicensePath(licensePath);
        installLogger.config(() -> "Setting license file: " + licensePath);
        LicenseInputStream is = this.getInputStream(licensePath);
        if (is == null) {
            installLogger.warning(() -> "License file not found: " + licensePath);
            throw new LicenseProcessingException(3, null, licensePath);
        }
        try {
            this.addLicenseFileContent(is.getInputStream(), is.isUrlPath(), cxlFileContents, licensePath);
        }
        catch (IOException ioex) {
            installLogger.log(Level.INFO, ioex, () -> "Problem reading license file: " + licensePath);
            installLogger.throwing(this.getClass().getName(), "setLicenseFile", ioex);
            throw new LicenseProcessingException(2, ioex, licensePath);
        }
    }

    public synchronized ArrayList<License> readLicensesFromFile(String path) throws LicenseProcessingException {
        HashSet<LicenseFileContent> contents = new HashSet<LicenseFileContent>();
        ArrayList<License> licenses = new ArrayList<License>();
        LicenseInputStream is = this.getInputStream(path);
        if (is == null) {
            return licenses;
        }
        try {
            this.addLicenseFileContent(is.getInputStream(), is.isUrlPath(), contents, path);
            for (LicenseFileContent license : contents) {
                this.verifyCXLContents(license, licenses);
            }
        }
        catch (Exception e) {
            installLogger.log(Level.INFO, e, () -> "Problem reading license file: " + path);
            installLogger.throwing(this.getClass().getName(), "readLicensesFromFile", e);
            throw new LicenseProcessingException(2, e, path);
        }
        return licenses;
    }

    private void addLicensePath(String path) {
        if (!licensePaths.contains(path)) {
            licensePaths.add(path);
        }
        lastLicensePath = path;
        installLogger.config(() -> "Full license path is set to: " + licensePaths);
    }

    public void setLastLicensePath(String path) {
        this.addLicensePath(path);
    }

    public String getFullLicensePath() {
        String licenseKey = LicenseManagerProperties.getInstance().getLicenseKey();
        if (licenseKey != null) {
            return LicenseManagerProperties.getInstance().getServer();
        }
        return String.join((CharSequence)";", licensePaths);
    }

    public String getLastLicensePath() {
        return lastLicensePath;
    }

    private Stream<License> getAllLicenses() {
        return Stream.of(licenses, this.remoteLicenseReader.getAvailableLicenses()).flatMap(Collection::stream).distinct();
    }

    public synchronized List<License> getLicensesFor(String product, String term) {
        return this.getAllLicenses().filter(l -> LicenseReader.licenseMatchesProduct(l, product)).filter(l -> LicenseReader.licenseMatchesTerm(l, term)).map(LicenseReader::safeLicenseClone).toList();
    }

    private static License safeLicenseClone(License license) {
        try {
            return license.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    private static boolean licenseMatchesProduct(License license, String product) {
        return product == null || product.equalsIgnoreCase(license.getSoftware());
    }

    private static boolean licenseMatchesTerm(License license, String term) {
        return term == null || term.equalsIgnoreCase(license.getLicenseTerm());
    }

    synchronized void ignoreRefresh(boolean b) {
        this.remoteLicenseReader = b ? FAKE_REMOTE_LICENSE_READER : VALID_REMOTE_LICENSE_READER;
    }

    private void readSystemProperty() {
        String licPath = this.getURLSystemProperty();
        installLogger.config(() -> "Searching for license file given with chemaxon.license.url Java system property: " + licPath);
        try {
            if (licPath != null) {
                installLogger.config(() -> "Location of license file specified as system property: " + licPath);
                this.readPaths(licPath);
            }
        }
        catch (SecurityException se) {
            LicenseExceptionHandler.getInstance().addPermissionProblem("Reading Java system property is not allowed: " + licPath);
            installLogger.log(Level.INFO, se, () -> "Reading Java system property is not allowed: {0}" + licPath);
        }
    }

    String getURLSystemProperty() {
        return System.getProperty(JAVA_PROPERTY_PATH);
    }

    String getURLEnvironmentVariable() {
        return System.getenv(ENVIRONMENT_VARIABLE_PATH);
    }

    private void readPaths(String pathString) {
        String[] paths;
        for (String path : paths = pathString.split(";")) {
            if (DEFAULT.equals(path)) {
                this.addLicensePath(path);
                continue;
            }
            LicenseInputStream is = this.getInputStreamFromVariable(path);
            if (is == null) continue;
            try {
                this.addLicenseFileContent(is.getInputStream(), is.isUrlPath(), cxlFileContents, path);
                this.addLicensePath(path);
                installLogger.config(() -> "Reading license file from: " + path);
            }
            catch (IOException e) {
                installLogger.warning(() -> "Reading file given as Java system property failed:" + path);
            }
        }
    }

    private void readEnvironmentVariable() {
        installLogger.config(() -> "Searching for license file given with environment variable: CHEMAXON_LICENSE_URL");
        String licPath = this.getURLEnvironmentVariable();
        try {
            if (licPath != null) {
                installLogger.config(() -> "Location of license file specified as system property. CHEMAXON_LICENSE_URL is " + licPath);
                this.readPaths(licPath);
            }
        }
        catch (SecurityException se) {
            LicenseExceptionHandler.getInstance().addPermissionProblem("Reading environment variable is not allowed: " + licPath);
            installLogger.log(Level.INFO, se, () -> "Reading environment variable is not allowed: " + licPath);
        }
    }

    private void readBuiltIn() {
        try {
            String path = "/chemaxon/license.cxl";
            InputStream is = LicenseHandler.class.getResourceAsStream(path);
            if (is != null) {
                installLogger.fine(() -> "Reading built-in license.cxl");
                this.addLicenseFileContent(is, false, cxlFileContents, path);
            }
        }
        catch (IOException e) {
            installLogger.log(Level.INFO, "Reading built-in license.cxl is failed", e);
        }
    }

    public String getDefaultLicensePath() {
        return this.getDefaultLicenseFile().getPath();
    }

    public File getDefaultLicenseFile() {
        return new File(DotfileUtil.getDotDir(), DEFAULT_LICENSE_FILE);
    }

    public File getDefaultLicensesFolder() {
        return new File(DotfileUtil.getDotDir(), DEFAULT_LICENSE_DIRECTORY);
    }

    private void readUserHome() {
        try {
            this.readLicenseFile(this.getDefaultLicensePath());
            File licenseDir = this.getDefaultLicensesFolder();
            if (licenseDir.exists() && licenseDir.isDirectory()) {
                this.readCxlFilesFromLicenseDirectory(licenseDir);
            }
        }
        catch (SecurityException se) {
            LicenseExceptionHandler.getInstance().addPermissionProblem("Reading license.cxl file from user home is not allowed: " + lastLicensePath);
            installLogger.log(Level.INFO, se, () -> "Reading license.cxl file from user home is not allowed: " + lastLicensePath);
        }
    }

    private void readCxlFilesFromLicenseDirectory(File directory) {
        for (File license : directory.listFiles()) {
            if (!LICENSE_FILE_EXTENSION.equals(LicenseReader.getExtension(license.getPath()))) continue;
            this.readLicenseFile(license.getPath());
        }
    }

    private static String getExtension(String fileName) {
        int index = fileName.lastIndexOf(46);
        return index == -1 ? "" : fileName.substring(index + 1);
    }

    private void readLicenseFile(String path) {
        try {
            FileInputStream is = new FileInputStream(path);
            this.addLicensePath(path);
            this.addLicenseFileContent(is, false, cxlFileContents, path);
            installLogger.config(() -> "Reading license file from user home: " + path);
        }
        catch (IOException e) {
            installLogger.config(() -> "Reading license file from user home failed: " + path);
        }
    }

    private void addLicenseFileContent(InputStream is, boolean urlPath, Set<LicenseFileContent> licenseFileContents, String path) throws IOException {
        LicenseExceptionHandler.getInstance().setLicenseRead(true);
        StringBuilder fileContent = new StringBuilder();
        try (InputStream inputStream = is;
             BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                fileContent.append(line).append("\n");
            }
            LicenseFileContent lfc = new LicenseFileContent(fileContent.toString(), urlPath, path);
            licenseFileContents.add(lfc);
        }
    }

    private LicenseInputStream getInputStream(String path) {
        try {
            File f = new File(path);
            FileInputStream fis = new FileInputStream(f);
            installLogger.fine(() -> "Creating FileInputStream from " + path);
            return new LicenseInputStream(fis, false);
        }
        catch (FileNotFoundException fnf) {
            InputStream is = LicenseHandler.class.getResourceAsStream(path);
            if (is != null) {
                installLogger.fine(() -> "Creating ResourceStream from " + path);
                return new LicenseInputStream(is, true);
            }
            installLogger.fine(() -> "Creating URLStream from " + path);
            return this.getURLStream(path);
        }
        catch (SecurityException se) {
            installLogger.log(Level.INFO, se, () -> "SecurityException occurred during get input stream by path: " + path);
            return null;
        }
    }

    private LicenseInputStream getInputStreamFromVariable(String licPath) {
        LicenseInputStream is = this.getURLStream(licPath);
        if (is != null) {
            return is;
        }
        try {
            String path = this.getCanonicalPath(licPath);
            installLogger.config(() -> "Using path: " + path);
            return new LicenseInputStream(new FileInputStream(path), false);
        }
        catch (FileNotFoundException fne) {
            installLogger.config(() -> "FileInputStream could not created from " + licPath);
            return null;
        }
    }

    private String getCanonicalPath(String licPath) {
        try {
            String canonicalPath = new File(licPath).getCanonicalPath();
            this.addLicensePath(canonicalPath);
            return canonicalPath;
        }
        catch (IOException e) {
            installLogger.config(() -> "Can not get canonical path of " + licPath);
            return licPath;
        }
    }

    private LicenseInputStream getURLStream(String path) {
        try {
            URL url = new URL(path);
            return new LicenseInputStream(url.openConnection().getInputStream(), true);
        }
        catch (Exception ex) {
            installLogger.log(Level.CONFIG, ex, () -> "URL stream could not be created from " + path);
            return null;
        }
    }

    private synchronized void verifyCXLContents(LicenseFileContent licenseFileContent, List<License> licenses) throws LicenseProcessingException {
        Collection<License> readLicenses;
        ByteArrayInputStream licenseInputStream = new ByteArrayInputStream(licenseFileContent.getContent().getBytes(StandardCharsets.UTF_8));
        if (verifier == null) {
            try {
                verifier = new XMLVerifier();
            }
            catch (NoSuchAlgorithmException e) {
                installLogger.log(Level.INFO, e, () -> "Fatal error - required java cryptography algorithm is not available.");
                throw new LicenseProcessingException(4, e);
            }
        }
        try {
            readLicenses = verifier.verifyXML(licenseInputStream);
        }
        catch (LicenseProcessingException e) {
            installLogger.log(Level.INFO, e.getMessage(), e);
            throw e;
        }
        catch (Exception e) {
            installLogger.log(Level.INFO, e, () -> "Problem reading license file: " + licenseFileContent.getPath());
            throw new LicenseProcessingException(1, e, licenseFileContent.getPath());
        }
        for (License lic : readLicenses) {
            if (licenses.contains(lic) || !this.contextAllowsLicense(lic) || licenseFileContent.isUrlPath() && lic.getRestriction("Server Use").equals("Not Allowed")) continue;
            licenses.add(lic);
        }
    }

    private boolean contextAllowsLicense(License license) {
        return this.licenseContextFilter.map(sd -> sd.accepts(license)).orElse(true);
    }

    public synchronized String report() {
        StringBuilder sb = new StringBuilder();
        LicenseReader.getInstance().getAllLicenses().forEach(lic -> LicenseReader.appendWithNewLibne(sb, lic));
        return sb.toString();
    }

    public static synchronized String report(String product, String term) {
        StringBuilder sb = new StringBuilder();
        LicenseReader.getInstance().getAllLicenses().filter(l -> LicenseReader.licenseMatchesProduct(l, product)).filter(l -> LicenseReader.licenseMatchesTerm(l, term)).forEach(lic -> LicenseReader.appendWithNewLibne(sb, lic));
        if (sb.isEmpty()) {
            sb.append("License is not found with the given condition.");
        }
        return sb.toString();
    }

    public synchronized String report(String product, String term, boolean expired) {
        StringBuilder sb = new StringBuilder();
        this.getAllLicenses().filter(l -> LicenseReader.licenseMatchesProduct(l, product)).filter(l -> LicenseReader.licenseMatchesTerm(l, term)).filter(l -> this.isExpired(l.getSoftware()) == expired).forEach(lic -> LicenseReader.appendWithNewLibne(sb, lic));
        if (sb.isEmpty()) {
            sb.append("License is not found with the given condition.");
        }
        return sb.toString();
    }

    private static void appendWithNewLibne(StringBuilder sb, License lic) {
        sb.append(lic);
        sb.append("\n");
    }

    public synchronized boolean isAboutToExpire(String product) {
        boolean expires = false;
        for (License lic : licenses) {
            if (!lic.getSoftware().equalsIgnoreCase(product) || lic.isExpired()) continue;
            if (lic.isAboutToExpire()) {
                expires = true;
                continue;
            }
            return false;
        }
        return expires;
    }

    public synchronized boolean isExpired(String product) {
        for (License lic : licenses) {
            if (!lic.getSoftware().equalsIgnoreCase(product) || lic.isExpired()) continue;
            return false;
        }
        return true;
    }

    private static class SingletonHolder {
        private static final LicenseReader INSTANCE = new LicenseReader();

        private SingletonHolder() {
        }
    }

    private static final class LicenseFileContent {
        private final String content;
        private final boolean urlPath;
        private final String path;

        private LicenseFileContent(String content, boolean urlPath, String path) {
            this.content = content;
            this.urlPath = urlPath;
            this.path = path;
        }

        public String getContent() {
            return this.content;
        }

        public boolean isUrlPath() {
            return this.urlPath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LicenseFileContent that = (LicenseFileContent)o;
            return Objects.equals(this.content, that.content) && this.urlPath == that.urlPath && Objects.equals(this.path, that.path);
        }

        public int hashCode() {
            int result = this.content != null ? this.content.hashCode() : 0;
            result = 31 * result + (this.urlPath ? 1 : 0);
            return result;
        }

        public String getPath() {
            return this.path;
        }
    }

    private static final class LicenseInputStream {
        private final InputStream inputStream;
        private final boolean urlPath;

        private LicenseInputStream(InputStream inputStream, boolean urlPath) {
            this.inputStream = inputStream;
            this.urlPath = urlPath;
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public boolean isUrlPath() {
            return this.urlPath;
        }
    }
}

