/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

import chemaxon.license.License;
import chemaxon.license.LicenseHandler;
import chemaxon.license.XMLWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

public final class LicenseProvider {
    private LicenseProvider() {
        throw new IllegalStateException("No LicenseProvider instance for you!");
    }

    public static Collection<License> getAvailableLicenses() {
        return LicenseProvider.getAvailableLicenses(null);
    }

    public static Collection<License> getAvailableLicenses(String product) {
        return LicenseHandler.getInstance().initAndGetLicenses(product, null);
    }

    public static String createLicenseXML() throws Exception {
        return LicenseProvider.createLicenseXML(LicenseProvider.getAvailableLicenses());
    }

    public static String createLicenseXML(String ... products) throws Exception {
        ArrayList<License> productLicenses = new ArrayList<License>();
        for (String product : products) {
            productLicenses.addAll(LicenseProvider.getAvailableLicenses(product));
        }
        return LicenseProvider.createLicenseXML(productLicenses);
    }

    public static String createLicenseXML(Collection<License> licenses) throws Exception {
        List<License> licenseList = LicenseProvider.sortLicenses(licenses);
        return new XMLWriter().writeXML(licenseList);
    }

    private static List<License> sortLicenses(Collection<License> licenses) {
        return licenses.stream().sorted(Comparator.comparing(License::getSoftware)).toList();
    }
}

