/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

public class LicenseProcessingException
extends Exception {
    public static final int XML_FORMING_EXCEPTION = 1;
    public static final int IO_EXCEPTION = 2;
    public static final int BAD_LOCATION_EXCEPTION = 3;
    public static final int NO_CRYPTOGRAPHY_ALG_EXCEPTION = 4;
    private static final String XML_FORMING_MESSAGE = "The license is not a well-formed xml";
    private static final String GENERAL_MESSAGE = "License processing problem occurred";
    private static final String IO_MESSAGE = "License reading problem occurred";
    private static final String BAD_LOCATION_MESSAGE = "License is not found";
    private static final String NO_CRYPTOGRAPHY_ALG_MESSAGE = "Fatal error - required java cryptography algorithm is not available.";

    public LicenseProcessingException(int type, Exception ex) {
        super(LicenseProcessingException.getMessage(type, null), ex);
    }

    public LicenseProcessingException(int type, Exception ex, String licensePath) {
        super(LicenseProcessingException.getMessage(type, licensePath), ex);
    }

    public LicenseProcessingException(String missingXMLTagMessage) {
        super(missingXMLTagMessage);
    }

    private static String getMessage(int type, String licensePath) {
        StringBuilder sb = new StringBuilder();
        switch (type) {
            case 1: {
                sb.append(XML_FORMING_MESSAGE);
                break;
            }
            case 2: {
                sb.append(IO_MESSAGE);
                break;
            }
            case 3: {
                sb.append(BAD_LOCATION_MESSAGE);
                break;
            }
            case 4: {
                sb.append(NO_CRYPTOGRAPHY_ALG_MESSAGE);
                break;
            }
            default: {
                sb.append(GENERAL_MESSAGE);
            }
        }
        LicenseProcessingException.appendPath(sb, licensePath);
        return sb.toString();
    }

    private static void appendPath(StringBuilder stringBuilder, String licensePath) {
        if (licensePath == null) {
            stringBuilder.append(".");
        } else {
            stringBuilder.append(": ");
            stringBuilder.append(licensePath);
        }
    }
}

