/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

import chemaxon.license.LicenseGlobals;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class LicensePackages {
    static final List<String> JCHEM_FOR_OFFICE_LITE_TECHNICAL_LICENSES = List.of("Marvin Beans", "ChemAxon .NET API");
    static final List<String> JCHEM_FOR_OFFICE_TECHNICAL_LICENSES = List.of("Marvin Beans", "ChemAxon .NET API", "JChem for Office Lite", "Structure Search", "MCES");
    static final List<String> JCHEM_FOR_OFFICE_BASIC_BUNDLE_TECHNICAL_LICENSES = List.of("Name to Structure", "Structure to Name", "Elemental Analyser Plugin", "Topological Polar Surface Area Plugin");
    static final List<String> JCHEM_FOR_OFFICE_STRUCTURAL_BUNDLE_TECHNICAL_LICENSES = List.of("Structural Calculations", "Isomers Plugin Group", "Structure Checker");
    static final List<String> JCHEM_FOR_OFFICE_MEDICINAL_CHEMISTRY_BUNDLE_TECHNICAL_LICENSES = List.of("Protonation Plugin Group", "Partitioning Plugin Group");
    static final List<String> JCHEM_FOR_OFFICE_DISCOVERY_BUNDLE_TECHNICAL_LICENSES = List.of("Solubility Plugin", "Synthesizer", "Standardizer", "Reactor");
    static final List<String> CHEMISTRY_FOR_OFFICE_BUNDLE_TECHNICAL_LICENSES = List.of("Structure Checker", "Name to Structure", "Structure to Name", "Structural Calculations", "Isomers Plugin Group", "Protonation Plugin Group", "Partitioning Plugin Group", "Solubility Plugin", "Elemental Analyser Plugin", "ADMET Plugin Group");
    static final List<String> JCHEM_BASE_LICENSES = List.of("JChem Base", "Structure Search", "Automapper", "MCES", "Marvin Beans");
    static final List<String> IJC_STRUCTURAL_LICENSES = List.of("Elemental Analyser Plugin", "Standardizer", "Instant JChem VIZ", "Isomers Plugin Group", "Structural Calculations", "Protonation Plugin Group", "Partitioning Plugin Group", "Plexus Connect", "HBDA Plugin", "Structure to Name", "Name to Structure", "Geometry Plugin Group");
    static final List<String> IJC_MEDICINAL_CHEMISTRY_LICENSES = List.of("Solubility Plugin", "ADMET Plugin Group");
    static final List<String> IJC_COMPUTATIONAL_CHEMISTRY_LICENSES = List.of("Reactor", "Markush Enumeration Plugin", "Markush Search");
    private static final List<String> MARVIN_PRO_LICENSES = List.of("JChem Microservices", "JChem Microservices Structure Manipulation", "JChem Microservices IO", "JChem Microservices Calculations", "Name to Structure");
    public static final List<String> STRUCTURAL_CALCULATIONS_IMPLICATIONS = List.of("Charge Plugin Group", "Conformation Plugin Group", "3D Alignment", "Geometry Plugin Group", "Huckel Analysis Plugin", "Refractivity Plugin", "HBDA Plugin", "Structural Frameworks Plugin");
    public static final Map<String, Set<String>> LICENSE_PACKAGES = Map.ofEntries(Map.entry("Structural Calculations", Set.copyOf(STRUCTURAL_CALCULATIONS_IMPLICATIONS)), Map.entry("JChem for Office Lite", LicensePackages.getJChemForOfficeLiteTechnicalLicenses()), Map.entry("JChem for Office", LicensePackages.getJChemForOfficeTechnicalLicenses()), Map.entry("JC4O Basic Bundle", LicensePackages.getJChemForOfficeBasicBundleTechnicalLicenses()), Map.entry("JC4O Structural Bundle", LicensePackages.getJChemForOfficeStructuralBundleTechnicalLicenses()), Map.entry("JC4O Medicinal Chemistry Bundle", LicensePackages.getJChemForOfficeMedicinalChemistryBundleTechnicalLicenses()), Map.entry("JC4O Discovery Bundle", LicensePackages.getJChemForOfficeDiscoveryBundleTechnicalLicenses()), Map.entry("Marvin Presenter Bundle", LicensePackages.getMarvinPresenterBundleTechnicalLicenses()), Map.entry("Marvin for Office Bundle", LicensePackages.getMarvinForOfficeBundleTechnicalLicenses()), Map.entry("Chemistry for Office", LicensePackages.getChemistryOfficeBundleTechnicalLicenses()), Map.entry("IJC Structural Bundle", LicensePackages.getIJCStructuralBundleLicenseDefinition()), Map.entry("IJC Medicinal Chemistry Bundle", LicensePackages.getIJCMedicinalChemistryBundleLicenseDefinition()), Map.entry("IJC Computational Chemistry Bundle", LicensePackages.getIJCComputationalChemistryBundleLicenseDefinition()), Map.entry("Marvin Pro", Set.copyOf(MARVIN_PRO_LICENSES)));

    private LicensePackages() {
        throw new IllegalAccessError();
    }

    public static Set<String> getImplicatedLicenses(String product) {
        return LICENSE_PACKAGES.getOrDefault(product, Set.of());
    }

    private static Set<String> getIJCStructuralBundleLicenseDefinition() {
        return LicensePackages.union(JCHEM_BASE_LICENSES, Set.of("Instant JChem"), IJC_STRUCTURAL_LICENSES);
    }

    private static Set<String> getIJCMedicinalChemistryBundleLicenseDefinition() {
        return LicensePackages.union(LicensePackages.getIJCStructuralBundleLicenseDefinition(), IJC_MEDICINAL_CHEMISTRY_LICENSES);
    }

    private static Set<String> getIJCComputationalChemistryBundleLicenseDefinition() {
        return LicensePackages.union(LicensePackages.getIJCMedicinalChemistryBundleLicenseDefinition(), IJC_COMPUTATIONAL_CHEMISTRY_LICENSES);
    }

    private static Set<String> getJChemForOfficeLiteTechnicalLicenses() {
        return LicensePackages.union(JCHEM_FOR_OFFICE_LITE_TECHNICAL_LICENSES, Set.of("JChem for Office Lite"));
    }

    private static Set<String> getJChemForOfficeTechnicalLicenses() {
        return LicensePackages.union(JCHEM_FOR_OFFICE_TECHNICAL_LICENSES, Set.of("JChem for Office", "JChem for Excel"));
    }

    private static Set<String> getJChemForOfficeBasicBundleTechnicalLicenses() {
        return LicensePackages.union(LicensePackages.getJChemForOfficeTechnicalLicenses(), Set.of("JC4O Basic Bundle"), JCHEM_FOR_OFFICE_BASIC_BUNDLE_TECHNICAL_LICENSES);
    }

    private static Set<String> getJChemForOfficeStructuralBundleTechnicalLicenses() {
        HashSet<String> implicated = new HashSet<String>(LicensePackages.getJChemForOfficeBasicBundleTechnicalLicenses());
        implicated.add("JC4O Structural Bundle");
        implicated.addAll(JCHEM_FOR_OFFICE_STRUCTURAL_BUNDLE_TECHNICAL_LICENSES);
        implicated.addAll(STRUCTURAL_CALCULATIONS_IMPLICATIONS);
        return implicated;
    }

    private static Set<String> getJChemForOfficeMedicinalChemistryBundleTechnicalLicenses() {
        HashSet<String> implicated = new HashSet<String>(LicensePackages.getJChemForOfficeStructuralBundleTechnicalLicenses());
        implicated.add("JC4O Medicinal Chemistry Bundle");
        implicated.addAll(JCHEM_FOR_OFFICE_MEDICINAL_CHEMISTRY_BUNDLE_TECHNICAL_LICENSES);
        return implicated;
    }

    private static Set<String> getJChemForOfficeDiscoveryBundleTechnicalLicenses() {
        HashSet<String> implicated = new HashSet<String>(LicensePackages.getJChemForOfficeMedicinalChemistryBundleTechnicalLicenses());
        implicated.add("JC4O Discovery Bundle");
        implicated.addAll(JCHEM_FOR_OFFICE_DISCOVERY_BUNDLE_TECHNICAL_LICENSES);
        implicated.addAll(LicenseGlobals.PLUGINS);
        return implicated;
    }

    private static Set<String> getMarvinPresenterBundleTechnicalLicenses() {
        return LicensePackages.union(LicensePackages.getJChemForOfficeLiteTechnicalLicenses(), Set.of("Marvin Presenter Bundle"));
    }

    private static Set<String> getMarvinForOfficeBundleTechnicalLicenses() {
        return LicensePackages.union(LicensePackages.getJChemForOfficeTechnicalLicenses(), Set.of("Marvin for Office Bundle"));
    }

    private static Set<String> getChemistryOfficeBundleTechnicalLicenses() {
        return LicensePackages.union(LicensePackages.getJChemForOfficeTechnicalLicenses(), Set.of("Marvin for Office Bundle"), CHEMISTRY_FOR_OFFICE_BUNDLE_TECHNICAL_LICENSES);
    }

    @SafeVarargs
    private static <T> Set<T> union(Collection<T> ... collections) {
        return Arrays.stream(collections).flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
    }
}

