/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

import chemaxon.common.util.CLQ;
import chemaxon.common.util.DotfileUtil;
import chemaxon.license.License;
import chemaxon.license.LicenseHandler;
import chemaxon.license.LicenseInstallation;
import chemaxon.license.LicenseLogFormatter;
import chemaxon.license.LicenseReportUserDataWriter;
import chemaxon.license.XMLReader;
import chemaxon.license.XMLWriter;
import com.chemaxon.version.VersionInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LicenseManagerTool {
    private static final String lineSep = System.getProperty("line.separator");
    static final String HELP_MESSAGE = lineSep + "License Manager Tool, (C) 1998-" + VersionInfo.getBuildYear() + " Chemaxon Ltd," + lineSep + "This will install Chemaxon license files, or lists the available Chemaxon licenses with their statuses." + lineSep + lineSep + "Usage:" + lineSep + "  license {hltpm} [license file path]" + lineSep + lineSep + "Options:" + lineSep + "  -h, --help                     print this help message" + lineSep + "  -r, --report <report file path> save the report to the given directory path" + lineSep + "                                   (default: save to the user home directory)" + lineSep + "  -l, --list <all|valid|invalid> list available licenses" + lineSep + "                                   all: all licenses" + lineSep + "                                   valid: valid licenses only" + lineSep + "                                   invalid: expired licenses only" + lineSep + "                                   (default: all)" + lineSep + "  -t, --term <license term>      list license(s) of the given term" + lineSep + "  -p, --product <product name>   list license(s) of the given product" + lineSep + "  -m, --merge                    merges 2 license files, see Example 5" + lineSep + "  <license file path>            install a license file from the given path" + lineSep + "  Installation merges the contains of the given license file with the already existing one," + lineSep + "  the merged file will be saved to user_home/chemaxon/license.cxl" + lineSep + lineSep + "Example 1: install a license file:" + lineSep + "  license c:/Temp/license.cxl" + lineSep + "Example 2: list all valid licenses of Standardizer:" + lineSep + "  license -p Standardizer" + lineSep + "Example 3: list all Evaluation licenses:" + lineSep + "  license -t Evaluation" + lineSep + "Example 4: list all expired Evaluation licenses:" + lineSep + "  license -l invalid -t Evaluation" + lineSep + "Example 5: merge 2 license files and save it as a new file:" + lineSep + "  license -m license.cxl ../license.cxl newlicense.cxl" + lineSep + "Example 6: save the report to the given path:" + lineSep + "  license -r c:/Temp";
    private static String product = null;
    private static String term = null;
    private static String list = null;
    private static String path = null;
    private static String path1 = null;
    private static String path2 = null;
    private static String outputPath = null;
    static Collection<License> newLicenses = new ArrayList<License>();
    private static final Logger installLogger = Logger.getLogger("cxl.license.install");

    private static void initLogger() throws SecurityException, IOException {
        File licenseLog = DotfileUtil.getDotFileWithEnsuredPath((String)"lic.log");
        FileHandler handler = new FileHandler(licenseLog.getAbsolutePath(), true);
        handler.setFormatter(new LicenseLogFormatter());
        installLogger.addHandler(handler);
        installLogger.addHandler(new ConsoleHandler());
    }

    public static void main(String[] args) throws Exception {
        if (!LicenseHandler.getInstance().isSoftwareInformationSet()) {
            LicenseHandler.getInstance().setSoftwareInformation("Chemaxon", "License Manager Tool");
        }
        if (LicenseManagerTool.processCmdLine(args)) {
            if (term != null || product != null || list != null) {
                if (list != null && !list.equals("all")) {
                    boolean expired = list.equals("invalid");
                    installLogger.info(() -> LicenseHandler.getInstance().report(product, term, expired));
                } else {
                    installLogger.info(() -> LicenseHandler.getInstance().report(product, term));
                }
            } else if (path1 != null) {
                LicenseManagerTool.merge(path1, path2, outputPath);
            } else {
                try {
                    String warningMessage = LicenseManagerTool.install(path);
                    if (warningMessage.length() > 0) {
                        System.out.println(warningMessage);
                    }
                }
                catch (Exception e) {
                    installLogger.log(Level.INFO, e.getLocalizedMessage(), e);
                    throw e;
                }
            }
        }
    }

    private static void merge(String path1, String path2, String outputPath) {
        try (FileInputStream is1 = new FileInputStream(path1);
             FileInputStream is2 = new FileInputStream(path2);
             FileOutputStream os = new FileOutputStream(outputPath);){
            XMLReader reader = new XMLReader();
            List<License> licenses1 = reader.readXML(is1);
            List<License> licenses2 = reader.readXML(is2);
            licenses1.addAll(licenses2);
            new XMLWriter().writeXML(licenses1, os);
        }
        catch (Exception e) {
            installLogger.log(Level.INFO, e, () -> "Error under merge licenses files. Merge file path1: " + path1 + ", merge file path2: " + path2 + " and output path: " + outputPath);
        }
    }

    public static synchronized String install(String licenseFile) throws Exception {
        LicenseInstallation installation = LicenseInstallation.installer().logger(installLogger).install(licenseFile);
        newLicenses = installation.getInstalledLicenses();
        return installation.getWarningMessage();
    }

    protected static boolean processCmdLine(String[] args) {
        if (args == null || args.length == 0) {
            System.out.println(HELP_MESSAGE);
            return false;
        }
        CLQ cmdLine = new CLQ(args, null);
        try {
            if (cmdLine.lookup("-h", "--help", "", 1, false, false) != null) {
                System.out.println(HELP_MESSAGE);
                return false;
            }
            CLQ.Parameter report = cmdLine.lookup("-r", "--report", "", 2, false, false);
            if (report != null) {
                String reportPath = report.getString();
                LicenseReportUserDataWriter writer = new LicenseReportUserDataWriter();
                writer.setTargetDirectory(reportPath);
                writer.generateReportFile();
                return false;
            }
            report = cmdLine.lookup("-r", "--report", "", 1, false, false);
            if (report != null) {
                LicenseReportUserDataWriter writer = new LicenseReportUserDataWriter();
                writer.generateReportFile();
                return false;
            }
            CLQ.Parameter tParam = cmdLine.lookup("-t", "--term", "", 2, false, false);
            term = tParam != null ? tParam.getString() : null;
            CLQ.Parameter pParam = cmdLine.lookup("-p", "--product", "", 2, false, false);
            product = pParam != null ? pParam.getString() : null;
            CLQ.Parameter lParam = cmdLine.lookup("-l", "--list", "", 2, false, false);
            String string = list = lParam != null ? lParam.getString().toLowerCase() : null;
            if (!(list == null || list.equals("all") || list.equals("valid") || list.equals("invalid"))) {
                installLogger.warning(() -> "Invalid list option: " + list);
                return false;
            }
            CLQ.Parameter merge = cmdLine.lookup("-m", "--merge", "", 4, false, false);
            if (merge != null) {
                path1 = merge.getString(0);
                path2 = merge.getString(1);
                outputPath = merge.getString(2);
            } else {
                path = cmdLine.notUsed();
            }
            return true;
        }
        catch (Exception e) {
            installLogger.log(Level.INFO, e, () -> "Error under process cmd line.List: " + list);
            return false;
        }
    }

    public static Collection<License> getNewLicenses() {
        return new ArrayList<License>(newLicenses);
    }

    static {
        if (installLogger.getHandlers().length == 0) {
            try {
                LicenseManagerTool.initLogger();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

