/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

import chemaxon.common.util.DotfileUtil;
import chemaxon.license.LicenseManagerPropertiesReader;
import chemaxon.license.TelemetryPropertiesReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LicenseManagerProperties
implements LicenseManagerPropertiesReader,
TelemetryPropertiesReader {
    private static final Logger logger = Logger.getLogger(LicenseManagerProperties.class.getName());
    static final String DEFAULT_SERVER_URL = "https://license.chemaxon.com";
    static final String DEFAULT_TELEMETRY_ENABLED = "true";
    static final String SERVER_URL_ENVIRONMENT_VARIABLE = "CHEMAXON_LICENSE_SERVER_URL";
    public static final String LICENSE_KEY_ENVIRONMENT_VARIABLE = "CHEMAXON_LICENSE_SERVER_KEY";
    public static final String TELEMETRY_ENABLED_ENVIRONMENT_VARIABLE = "CHEMAXON_TELEMETRY_ENABLED";
    static final String SERVER_URL_JVM_PROPERTY = "chemaxon.license.server.url";
    static final String LICENSE_KEY_JVM_PROPERTY = "chemaxon.license.server.key";
    static final String LICENSE_MANAGER_FILE = "license-manager.properties";
    static final String LICENSE_KEY = "license-key";
    static final String LICENSE_SERVER_URL = "server";
    static final String TELEMETRY_ENABLED = "telemetry-enabled-chemaxon-internal";
    private final Properties properties = new Properties();
    private static final LicenseManagerProperties instance = new LicenseManagerProperties();

    private LicenseManagerProperties() {
        this.readPropertiesFromFile();
        this.readPropertiesFromEnvironmentVariable();
        this.readPropertiesFromJvmProperties();
    }

    private void readPropertiesFromFile() {
        File f = new File(DotfileUtil.getDotDir(), LICENSE_MANAGER_FILE);
        if (f.exists()) {
            try (FileInputStream fis = new FileInputStream(f);){
                this.properties.load(fis);
            }
            catch (Exception e) {
                logger.log(Level.INFO, e, () -> "Failed to read remote license configuration. File name: license-manager.properties");
            }
        }
    }

    private void readPropertiesFromEnvironmentVariable() {
        this.setIfNotNull(System::getenv, SERVER_URL_ENVIRONMENT_VARIABLE, LICENSE_SERVER_URL);
        this.setIfNotNull(System::getenv, LICENSE_KEY_ENVIRONMENT_VARIABLE, LICENSE_KEY);
        this.setIfNotNull(System::getenv, TELEMETRY_ENABLED_ENVIRONMENT_VARIABLE, TELEMETRY_ENABLED);
    }

    private void readPropertiesFromJvmProperties() {
        this.setIfNotNull(System::getProperty, SERVER_URL_JVM_PROPERTY, LICENSE_SERVER_URL);
        this.setIfNotNull(System::getProperty, LICENSE_KEY_JVM_PROPERTY, LICENSE_KEY);
    }

    public static LicenseManagerProperties getInstance() {
        return instance;
    }

    public void setLicenseKey(String licenseKey) {
        this.properties.setProperty(LICENSE_KEY, licenseKey);
    }

    @Override
    public String getLicenseKey() {
        return this.properties.getProperty(LICENSE_KEY, null);
    }

    public void setServer(String server) {
        this.properties.setProperty(LICENSE_SERVER_URL, server);
    }

    @Override
    public String getServer() {
        return this.properties.getProperty(LICENSE_SERVER_URL, DEFAULT_SERVER_URL);
    }

    @Override
    public boolean isTelemetryEnabled() {
        return Boolean.parseBoolean(this.properties.getProperty(TELEMETRY_ENABLED, DEFAULT_TELEMETRY_ENABLED));
    }

    @Override
    public Supplier<String> getLicenseKeyProvider() {
        return this::getLicenseKey;
    }

    public void save() throws IOException {
        File f = DotfileUtil.getDotFileWithEnsuredPath((String)LICENSE_MANAGER_FILE);
        try (FileOutputStream os = new FileOutputStream(f);){
            this.properties.store(os, null);
        }
    }

    private void setIfNotNull(UnaryOperator<String> getter, String keyToGet, String keyToSet) {
        String value = (String)getter.apply(keyToGet);
        if (value != null) {
            this.properties.setProperty(keyToSet, value);
        }
    }
}

