/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

class LicenseLogFormatter
extends Formatter {
    private final MessageFormat format = new MessageFormat("{0,date} {0,time}");
    private final String lineSeparator = System.getProperty("line.separator");

    LicenseLogFormatter() {
    }

    @Override
    public synchronized String format(LogRecord record) {
        Date date = new Date();
        date.setTime(record.getMillis());
        StringBuffer dateText = new StringBuffer();
        this.format.format(new Object[]{date}, dateText, (FieldPosition)null);
        StringBuilder sb = new StringBuilder();
        sb.append(dateText);
        sb.append(". ");
        sb.append(record.getLoggerName());
        sb.append(" ");
        sb.append(record.getLevel().getLocalizedName());
        sb.append(": ");
        sb.append(this.formatMessage(record));
        sb.append(this.lineSeparator);
        if (record.getThrown() != null) {
            Throwable exception = record.getThrown();
            sb.append(Arrays.toString(exception.getStackTrace()).replace(',', '\n'));
        }
        return sb.toString();
    }
}

