/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

import chemaxon.common.util.DotfileUtil;
import chemaxon.license.License;
import chemaxon.license.XMLReader;
import chemaxon.license.XMLWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;

class LicenseInstallation {
    private static final String WARNING_START = "License(s) contained in installed license file will be installed only\nin the Chemaxon home directory of the local computer, paths given\n";
    private static final String WARNING_END = "\nremain unaffected.";
    private String warningMessage = "";
    private Collection<License> installedLicenses;

    private LicenseInstallation(Installer installer, String licenseFilePath) throws Exception {
        InputStream licenseFileInputStream = null;
        boolean serverOnly = false;
        if (LicenseInstallation.isURL(licenseFilePath)) {
            URLConnection conn = new URL(licenseFilePath).openConnection();
            licenseFileInputStream = conn.getInputStream();
            serverOnly = true;
        } else {
            File lf = new File(licenseFilePath);
            if (lf.exists()) {
                licenseFileInputStream = new FileInputStream(lf);
            }
        }
        if (licenseFileInputStream == null) {
            this.warningMessage = "Can't open license file on path: " + licenseFilePath;
            installer.logger.warning(this.warningMessage);
            return;
        }
        String location = installer.licenseFileLocation;
        XMLReader reader = new XMLReader();
        List<Object> licenses = new ArrayList();
        try {
            FileInputStream defis = new FileInputStream(location);
            licenses = reader.readXML(defis);
            ((InputStream)defis).close();
        }
        catch (Exception ex) {
            installer.logger.fine("License file not exist yet.");
        }
        this.installedLicenses = reader.readXML(licenseFileInputStream);
        licenseFileInputStream.close();
        if (serverOnly) {
            this.installedLicenses.removeIf(lic -> lic.getRestriction("Server Use").equals("Not Allowed"));
        }
        licenses.addAll(this.installedLicenses);
        List<License> sortedLicenses = LicenseInstallation.sortDescending(licenses);
        ArrayList<License> merged = new ArrayList<License>();
        for (License l : sortedLicenses) {
            if (l.getRestriction("B/S/P/E") == null) {
                if (LicenseInstallation.getLicenseWithSoftware(merged, l.getSoftware()) != null) continue;
                merged.add(l);
                continue;
            }
            if (LicenseInstallation.getLicenseWithSoftwareAndBSPE(merged, l.getSoftware(), l.getRestriction("B/S/P/E")) != null) continue;
            merged.add(l);
        }
        try {
            installer.logger.config(() -> "Try to save license to " + location);
            LicenseInstallation.write(licenses, new FileOutputStream(location));
        }
        catch (IOException e) {
            installer.logger.severe(() -> "can't write to path " + location + "\n" + e.getMessage());
            throw new IOException("Can't install license file to the location " + location, e);
        }
        catch (SecurityException e) {
            installer.logger.severe(() -> "can't write to path " + location + "\n" + e.getMessage());
            throw new SecurityException("Can't install license file to the location " + location, e);
        }
        this.warningMessage = LicenseInstallation.warningIfURLPropSet(installer);
    }

    static Installer installer() {
        return new Installer();
    }

    public String getWarningMessage() {
        return this.warningMessage;
    }

    public Collection<License> getInstalledLicenses() {
        return this.installedLicenses;
    }

    private static String warningIfURLPropSet(Installer installer) {
        String envPath;
        Object warningMessage = "";
        String javaPropPath = System.getProperty(installer.propertyName);
        if (javaPropPath != null) {
            warningMessage = "License(s) contained in installed license file will be installed only\nin the Chemaxon home directory of the local computer, paths given\nin the Java system property \"chemaxon.license.url\"";
        }
        if ((envPath = System.getenv(installer.variableName)) != null) {
            warningMessage = ((String)warningMessage).isEmpty() ? WARNING_START : (String)warningMessage + " and\n";
            warningMessage = (String)warningMessage + "in the environment variable CHEMAXON_LICENSE_URL";
        }
        if (((String)warningMessage).length() > 0) {
            warningMessage = (String)warningMessage + WARNING_END;
        }
        return warningMessage;
    }

    private static void write(List<License> licenses, OutputStream os) throws Exception {
        XMLWriter writer = new XMLWriter();
        writer.writeXML(licenses, os);
        os.close();
    }

    private static List<License> sortDescending(Collection<License> licenses) {
        ArrayList<License> sortedLicenses = new ArrayList<License>(licenses);
        Collections.sort(sortedLicenses, Comparator.reverseOrder());
        return sortedLicenses;
    }

    private static License getLicenseWithSoftware(List<License> licenses, String software) {
        for (License l : licenses) {
            if (!l.getSoftware().equals(software)) continue;
            return l;
        }
        return null;
    }

    private static License getLicenseWithSoftwareAndBSPE(List<License> licenses, String software, String bspe) {
        for (License l : licenses) {
            if (!l.getSoftware().equals(software) || !bspe.equals(l.getRestriction("B/S/P/E"))) continue;
            return l;
        }
        return null;
    }

    private static boolean isURL(String path) {
        return path.startsWith("http:/") || path.startsWith("https:/") || path.startsWith("ftp:/") || path.startsWith("file:/");
    }

    static final class Installer {
        private String licenseFileLocation = DotfileUtil.getDotFile((String)"license.cxl").getPath();
        private Logger logger = Logger.getLogger("global");
        private String variableName = "CHEMAXON_LICENSE_URL";
        private String propertyName = "chemaxon.license.url";

        Installer() {
        }

        Installer licenseFileLocation(String path) {
            this.licenseFileLocation = path;
            return this;
        }

        Installer environmentVariable(String variableName) {
            this.variableName = variableName;
            return this;
        }

        Installer systemProperty(String propertyName) {
            this.propertyName = propertyName;
            return this;
        }

        Installer logger(Logger logger) {
            this.logger = logger;
            return this;
        }

        LicenseInstallation install(String licenseFilePath) throws Exception {
            return new LicenseInstallation(this, licenseFilePath);
        }
    }
}

