/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

import chemaxon.common.util.DotfileUtil;
import chemaxon.license.LicenseReader;
import java.io.File;
import java.io.IOException;

public class LicenseInfoLogger {
    private static final System.Logger LOG = System.getLogger(LicenseInfoLogger.class.getName());
    private static final String DOC_URL = "https://docs.chemaxon.com/display/docs/Installing_to_Servers.html";

    private LicenseInfoLogger() {
    }

    public static void printLicenceFileInfo() throws IOException {
        LOG.log(System.Logger.Level.INFO, "############################################# Licence file information #############################################");
        LicenseInfoLogger.checkEnvironmentVariable();
        LicenseInfoLogger.checkProperty();
        LicenseInfoLogger.checkUserLicence();
        LOG.log(System.Logger.Level.INFO, "You can read more about Licence installation at: {}", DOC_URL);
        LOG.log(System.Logger.Level.INFO, "######################################### End of licence file information #########################################");
    }

    private static void checkUserLicence() throws IOException {
        LOG.log(System.Logger.Level.INFO, "Running user is: {}", System.getProperty("user.name"));
        LOG.log(System.Logger.Level.INFO, "Running user's home: {}", System.getProperty("user.home"));
        LOG.log(System.Logger.Level.INFO, "Chemaxon home is: {}", DotfileUtil.getDotDir().getCanonicalPath());
        LicenseInfoLogger.checkLicenceCxl();
        LicenseInfoLogger.checkLicencesDir();
    }

    private static void checkLicencesDir() throws IOException {
        File licensesDir = LicenseReader.getInstance().getDefaultLicensesFolder();
        LOG.log(System.Logger.Level.INFO, "Licenses can also be installed in: {}", licensesDir.getCanonicalPath());
        if (licensesDir.exists()) {
            LOG.log(System.Logger.Level.INFO, "{} exists", licensesDir.getCanonicalPath());
            String[] licFiles = licensesDir.list();
            if (licFiles != null && licFiles.length != 0) {
                for (String licFile : licFiles) {
                    LOG.log(System.Logger.Level.INFO, "Additional licence: {}", new File(licensesDir, licFile).getCanonicalPath());
                }
            } else {
                LOG.log(System.Logger.Level.INFO, "No additional licence found in {}", licensesDir.getCanonicalPath());
            }
        } else {
            LOG.log(System.Logger.Level.INFO, "{} does not exist", licensesDir.getCanonicalPath());
        }
    }

    private static void checkLicenceCxl() throws IOException {
        File licenseCxl = LicenseReader.getInstance().getDefaultLicenseFile();
        if (licenseCxl.exists()) {
            LOG.log(System.Logger.Level.INFO, "license.cxl can be found at: {}", licenseCxl.getCanonicalPath());
        } else {
            LOG.log(System.Logger.Level.INFO, "license.cxl cannot be found at: {}", licenseCxl.getCanonicalPath());
        }
    }

    private static void checkProperty() {
        String prop = System.getProperty("chemaxon.license.url");
        if (prop != null && !prop.isEmpty()) {
            LOG.log(System.Logger.Level.INFO, "{} runtime property is set to: {}", "chemaxon.license.url", prop);
        } else {
            LOG.log(System.Logger.Level.INFO, "{} runtime property is not set", "chemaxon.license.url");
            LOG.log(System.Logger.Level.INFO, "You can set it to java like -D{}=path/to/license.cxl", "chemaxon.license.url");
        }
    }

    private static void checkEnvironmentVariable() {
        String env = System.getenv("CHEMAXON_LICENSE_URL");
        if (env != null && !env.isEmpty()) {
            LOG.log(System.Logger.Level.INFO, "{} environment variable is set to: {}", "CHEMAXON_LICENSE_URL", env);
        } else {
            LOG.log(System.Logger.Level.INFO, "{} environment variable is not set", "CHEMAXON_LICENSE_URL");
        }
    }
}

