/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

import chemaxon.common.util.DotfileUtil;
import chemaxon.license.License;
import chemaxon.license.LicenseConverter;
import chemaxon.license.LicenseException;
import chemaxon.license.LicenseExceptionHandler;
import chemaxon.license.LicenseGlobals;
import chemaxon.license.LicenseLogFormatter;
import chemaxon.license.LicenseManagerProperties;
import chemaxon.license.LicenseProcessingException;
import chemaxon.license.LicenseProvider;
import chemaxon.license.LicenseReader;
import chemaxon.license.LicenseThread;
import chemaxon.license.Ruleset;
import chemaxon.license.SoftwareDescriptor;
import chemaxon.license.TelemetryPropertiesProvider;
import chemaxon.license.TelemetryService;
import chemaxon.license.TelemetryServiceFactory;
import com.chemaxon.common.annotations.RemovalDate;
import com.chemaxon.common.annotations.SubjectToRemoval;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public final class LicenseHandler {
    private final AtomicReference<SoftwareDescriptor> softwareDescriptor = new AtomicReference<Object>(null);
    private volatile boolean processed = false;
    boolean addTestLicenses = false;
    private final TelemetryService telemetryService;
    private final Map<String, Long> validLicenses = new ConcurrentHashMap<String, Long>();
    private final Map<String, Set<License>> technicalLicenses = new ConcurrentHashMap<String, Set<License>>();
    private final Map<String, Map<String, Long>> internalLicenseUsages = new HashMap<String, Map<String, Long>>();
    public String globalLicenseEnvironment;
    private final InternalLicenseUsageChecker internalUsageChecker = new InternalLicenseUsageChecker();
    volatile boolean ignoreRefresh = false;
    static Logger verifyLogger = Logger.getLogger("cxl.license.verify");
    static Logger installLogger = Logger.getLogger("cxl.license.install");
    static Logger generalLogger = Logger.getLogger("cxl.license.general");
    static Logger telemetryLogger = Logger.getLogger("cxl.license.telemetry");
    private static final Comparator<License> PRODUCT_EDITION_COMPARATOR = (o1, o2) -> {
        String restriction1 = o1.getRestriction("B/S/P/E");
        String restriction2 = o2.getRestriction("B/S/P/E");
        if (restriction1 == null && restriction2 == null) {
            return 0;
        }
        if (restriction1 == null) {
            return 1;
        }
        if (restriction2 == null) {
            return 1;
        }
        if (restriction1.equals("Enterprise") && !restriction2.equals("Enterprise")) {
            return -1;
        }
        if (!restriction1.equals("Enterprise") && restriction2.equals("Enterprise")) {
            return 1;
        }
        if (restriction1.equals("Basic") && !restriction2.equals("Basic")) {
            return 1;
        }
        if (!restriction1.equals("Basic") && restriction2.equals("Basic")) {
            return -1;
        }
        if (restriction1.equals("Standard") && restriction2.equals("Professional")) {
            return 1;
        }
        if (restriction1.equals("Professional") && restriction2.equals("Standard")) {
            return -1;
        }
        return 0;
    };

    private LicenseHandler() {
        this.initLoggers();
        LicenseReader.getInstance().setLoggers(installLogger);
        this.addBuiltInLicenses();
        LicenseReader.getInstance().read();
        this.telemetryService = TelemetryServiceFactory.getTelemetryService(TelemetryPropertiesProvider.of(LicenseManagerProperties.getInstance()));
    }

    public static LicenseHandler getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public synchronized void init() {
        if (!this.processed) {
            try {
                this.process();
            }
            catch (LicenseProcessingException e) {
                installLogger.log(Level.INFO, e, () -> "Problem during initialize.");
            }
        }
    }

    public synchronized void process() throws LicenseProcessingException {
        this.telemetryService.startService();
        this.processed = false;
        try {
            LicenseReader.getInstance().fetch();
        }
        finally {
            this.convertToTechnicalLicense(LicenseReader.getInstance().getLicensesFor(null, null));
        }
        this.processed = true;
    }

    public synchronized void refresh() {
        this.technicalLicenses.clear();
        LicenseReader.getInstance().read();
        try {
            this.process();
        }
        catch (LicenseProcessingException lpe) {
            installLogger.log(Level.INFO, lpe, () -> "Problem during refresh. Reading license file: " + LicenseReader.getInstance().getLastLicensePath());
        }
    }

    public void setLicenseFile(String licensePath) throws LicenseProcessingException {
        LicenseReader.getInstance().setLicenseFile(licensePath);
        this.process();
    }

    public void setLicense(String s) throws LicenseProcessingException {
        LicenseReader.getInstance().setLicense(s);
        this.process();
    }

    private synchronized void initLoggers() {
        try {
            File licenseLog = new File(DotfileUtil.getDotDir().getAbsolutePath(), "lic.log");
            FileHandler handler = new FileHandler(licenseLog.getAbsolutePath(), true);
            handler.setFormatter(new LicenseLogFormatter());
            verifyLogger.addHandler(handler);
            installLogger.addHandler(handler);
            generalLogger.addHandler(handler);
            telemetryLogger.addHandler(handler);
            if (System.getProperty("chemaxon.license.install.verbose") != null) {
                this.setFinerLevel(verifyLogger);
                this.setFinerLevel(installLogger);
                this.setFinerLevel(generalLogger);
                this.setFinerLevel(telemetryLogger);
            }
        }
        catch (IOException | SecurityException exception) {
            // empty catch block
        }
    }

    private void setFinerLevel(Logger logger) {
        logger.setLevel(Level.FINER);
        Handler[] handlers = logger.getHandlers();
        if (handlers.length == 0) {
            try {
                logger.addHandler(new ConsoleHandler());
            }
            catch (SecurityException securityException) {}
        } else {
            for (Handler handler : handlers) {
                if (!(handler instanceof ConsoleHandler)) continue;
                handler.setLevel(Level.FINER);
            }
        }
    }

    public List<String> getProductList(boolean includePlugins) {
        if (includePlugins) {
            ArrayList<String> list = new ArrayList<String>();
            list.addAll(LicenseGlobals.PRODUCTS);
            list.addAll(LicenseGlobals.PLUGINS);
            return list;
        }
        return LicenseGlobals.PRODUCTS;
    }

    public List<String> getPluginList() {
        return LicenseGlobals.PLUGINS;
    }

    public String getLicenseExceptionMessage() {
        return LicenseExceptionHandler.getInstance().getLicenseExceptionMessage();
    }

    public String getLicenseExceptionMessage(String product) {
        return LicenseExceptionHandler.getInstance().getLicenseExceptionMessage(product);
    }

    public String getFullLicensePath() {
        return LicenseReader.getInstance().getFullLicensePath();
    }

    public String getLastLicensePath() {
        return LicenseReader.getInstance().getLastLicensePath();
    }

    public synchronized void removeAllReadLicenses() {
        LicenseReader.getInstance().clear();
        this.validLicenses.clear();
        this.internalLicenseUsages.clear();
        this.addBuiltInLicenses();
    }

    public synchronized void removeAllLicenses() {
        LicenseReader.getInstance().clear();
        this.technicalLicenses.clear();
        this.validLicenses.clear();
        this.internalLicenseUsages.clear();
    }

    @Deprecated(forRemoval=true)
    @SubjectToRemoval(date=RemovalDate.JUL_01_2025)
    public void runWithoutAnyLicense(Runnable action) {
        this.runWithoutAnyLicenseExcept(null, action);
    }

    @Deprecated(forRemoval=true)
    @SubjectToRemoval(date=RemovalDate.JUL_01_2025)
    public synchronized void runWithoutAnyLicenseExcept(String keepLicense, Runnable action) {
        try {
            this.refresh();
            this.ignoreRefresh(true);
            LicenseReader.getInstance().clear();
            this.validLicenses.keySet().removeIf(license -> keepLicense == null || !keepLicense.equals(license));
            this.internalLicenseUsages.clear();
            this.addBuiltInLicenses();
            action.run();
        }
        finally {
            this.ignoreRefresh(false);
            this.refresh();
        }
    }

    public synchronized boolean isDemoModePluginOnly(String plugin) {
        if ("Name to Structure".equals(plugin) || "Structure to Name".equals(plugin)) {
            return false;
        }
        if (LicenseHandler.getInstance().isLicensed("Calculations Pack")) {
            return false;
        }
        this.init();
        long time = System.currentTimeMillis();
        boolean hasValidLicense = this.hasValidLicense(plugin, time);
        boolean internallyLicensed = this.internalUsageChecker.isLicensed(plugin, time, null);
        return !hasValidLicense && internallyLicensed;
    }

    public boolean isLicensed(String product) {
        return this.isLicensed(product, "");
    }

    public boolean isLicensed(String product, String env) {
        return this.isLicensed(product, env, null);
    }

    public boolean isLicensed(String product, String env, Class<?> classDeniedInternalUsage) {
        boolean checkResult = this.licenseCheck(product, env, classDeniedInternalUsage);
        this.telemetryService.registerLicenseUsageData(product, checkResult);
        return checkResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean licenseCheck(String product, String env, Class<?> classDeniedInternalUsage) {
        verifyLogger.fine(() -> "Check license on " + product + " product, on " + env + " env and " + classDeniedInternalUsage + " classDeniedInternalUsage.");
        long time = System.currentTimeMillis();
        if (this.processed && this.hasValidLicense(product, time)) {
            return true;
        }
        LicenseHandler licenseHandler = this;
        synchronized (licenseHandler) {
            this.init();
            if (this.hasValidLicense(product, time)) {
                verifyLogger.fine(() -> "Valid license check passed: " + product);
                return true;
            }
            if (this.isLicensedInGlobalLicenseEnvironment(product, time)) {
                return true;
            }
            if (this.isLicensedQuickCheck(product, env, time)) {
                verifyLogger.fine(() -> "Quick check passed with product: " + product + ", and env: " + env);
                return true;
            }
            verifyLogger.fine(() -> "Check internal usage: " + product);
            return this.internalUsageChecker.isLicensed(product, time, classDeniedInternalUsage);
        }
    }

    private boolean isLicensedInGlobalLicenseEnvironment(String product, long time) {
        if (this.globalLicenseEnvironment != null && !this.globalLicenseEnvironment.isEmpty()) {
            verifyLogger.fine(() -> "Check with global license environment.");
            if (this.isLicensedQuickCheck(product, this.globalLicenseEnvironment, time)) {
                verifyLogger.fine(() -> "Quick check passed with product: " + product + ", and global license env: " + this.globalLicenseEnvironment);
                return true;
            }
        }
        return false;
    }

    private boolean hasValidLicense(String product, long currentTime) {
        Long expTime = this.validLicenses.get(product);
        if (expTime != null) {
            if (currentTime <= expTime) {
                return true;
            }
            this.validLicenses.remove(product);
        }
        return false;
    }

    private boolean isLicensedQuickCheck(String product, String environment, long currentTime) {
        Map<String, Long> extraLicenses;
        if (this.internalLicenseUsages.containsKey(product) && (extraLicenses = this.internalLicenseUsages.get(product)).containsKey(environment)) {
            long expTime = extraLicenses.get(environment);
            if (currentTime <= expTime) {
                return true;
            }
            this.internalLicenseUsages.remove(product);
        }
        return false;
    }

    public synchronized String getProductEdition(String product) {
        this.init();
        ArrayList<License> licenses = new ArrayList<License>(LicenseProvider.getAvailableLicenses(product));
        Collections.sort(licenses, PRODUCT_EDITION_COMPARATOR);
        String edition = null;
        if (!licenses.isEmpty()) {
            edition = ((License)licenses.get(0)).getRestriction("B/S/P/E");
        }
        return edition == null ? "" : edition;
    }

    public synchronized int getJChemSearchPerMin() {
        if ("InstantJChemLicenseEnvironment".equals(this.globalLicenseEnvironment) || "TaylorAndFrancisPublicationLicenseEnvironment".equals(this.globalLicenseEnvironment) || "JChemForSharePointLicenseEnvironment".equals(this.globalLicenseEnvironment) || "JChemOracleCartridgeLicenseEnvironment".equals(this.globalLicenseEnvironment)) {
            return Integer.MAX_VALUE;
        }
        this.init();
        return LicenseReader.getInstance().getJChemSearchPerMin();
    }

    public void checkLicense(String product) throws LicenseException {
        this.checkLicense(product, "");
    }

    public void checkLicense(String product, String env) throws LicenseException {
        this.checkLicense(product, env, null);
    }

    public void checkLicense(String product, String env, Class<?> classDeniedInternalUsage) throws LicenseException {
        if (!this.licenseCheck(product, env, classDeniedInternalUsage)) {
            if (this.ignoreRefresh) {
                this.telemetryService.registerLicenseUsageData(product, false);
                throw new LicenseException(product, env);
            }
            this.refresh();
            if (!this.licenseCheck(product, env, classDeniedInternalUsage)) {
                if (product.equals("Reactor") && env != null && env.equals("JChem Cartridge")) {
                    this.telemetryService.registerLicenseUsageData(product, false);
                    throw new LicenseException(product + " Professional", env);
                }
                this.telemetryService.registerLicenseUsageData(product, false);
                throw new LicenseException(product, env);
            }
        }
        this.telemetryService.registerLicenseUsageData(product, true);
    }

    public synchronized void setGlobalLicenseEnvironment(String globalLicenseEnvironment) {
        this.globalLicenseEnvironment = globalLicenseEnvironment;
    }

    public synchronized void registerInternalLicense(String clazz, List<String> licenses) {
        if (this.internalUsageChecker.isLegalEnvironment("com.im.commons.misc.LicenseRegistration")) {
            for (String license : licenses) {
                if (!license.equals("JChem Base") && !LicenseHandler.getInstance().isLicensed("Calculations Pack")) {
                    return;
                }
                this.registerAnInternalLicense(clazz, license);
            }
        }
    }

    void registerAnInternalLicense(String clazz, String license) {
        Map<String, Long> extraLicenses = this.internalLicenseUsages.get(license);
        if (extraLicenses == null) {
            extraLicenses = new HashMap<String, Long>();
        }
        extraLicenses.put(clazz, Long.MAX_VALUE);
        this.internalLicenseUsages.put(license, extraLicenses);
    }

    public synchronized List<License> initAndGetLicenses(String product, String term) {
        this.init();
        return LicenseReader.getInstance().getLicensesFor(product, term);
    }

    public synchronized String report() {
        this.init();
        return LicenseReader.getInstance().report();
    }

    public synchronized String report(String product, String term) {
        this.init();
        return LicenseReader.report(product, term);
    }

    public synchronized String report(String product, String term, boolean expired) {
        this.init();
        return LicenseReader.getInstance().report(product, term, expired);
    }

    public void ignoreRefresh(boolean b) {
        this.ignoreRefresh = b;
        LicenseReader.getInstance().ignoreRefresh(b);
    }

    public void addTestLicenses(boolean b) {
        this.addTestLicenses = b;
    }

    private synchronized void addBuiltInLicenses() {
        LicenseConverter.createRuleset(this.addTestLicenses).convert(License.ALWAYS_GRANTED_LICENSE, this::registerLicenseImplication);
    }

    private synchronized void convertToTechnicalLicense(List<License> readLicenses) {
        Ruleset ruleset = LicenseConverter.createRuleset(this.addTestLicenses);
        for (License license : readLicenses) {
            ruleset.convert(license, this::registerLicenseImplication);
        }
    }

    private void registerLicenseImplication(License license, String environment, String impliedProduct) {
        long expiration = license.getExpirationTime();
        BiFunction<Object, Long, Long> remappingFunction = (p, time) -> time == null || time < expiration ? expiration : time;
        if (environment == null) {
            this.validLicenses.compute(impliedProduct, remappingFunction);
            this.safeGetImplicatingLicenses(impliedProduct).add(license);
        } else {
            this.internalLicenseUsages.computeIfAbsent(impliedProduct, k -> new HashMap()).compute(environment, remappingFunction);
        }
    }

    public List<String> getCallStackList() {
        return this.internalUsageChecker.getCallStackList();
    }

    public Collection<License> getTechnicalLicenses(String product) {
        Set<License> implicatingLicenses = this.safeGetImplicatingLicenses(product);
        return implicatingLicenses.stream().filter(l -> l.isValid() || l.isAboutToExpire()).collect(Collectors.toSet());
    }

    @Deprecated(forRemoval=true)
    @SubjectToRemoval(date=RemovalDate.JUL_01_2025)
    public void setTechnicalLiscense(String product, License implicatedBy) {
        this.safeGetImplicatingLicenses(product).add(implicatedBy);
    }

    public Set<String> getImplicatedLicenses() {
        return this.technicalLicenses.keySet();
    }

    public Set<String> getInternalLicenses() {
        return this.internalLicenseUsages.keySet();
    }

    private Set<License> safeGetImplicatingLicenses(String product) {
        return this.technicalLicenses.computeIfAbsent(product, s -> new HashSet());
    }

    public boolean trySettingSoftwareInformation(String vendor, String product) {
        SoftwareDescriptor descriptor = SoftwareDescriptor.create(vendor, product);
        boolean success = this.softwareDescriptor.compareAndSet(null, descriptor);
        if (success) {
            this.updateLicenseReaderWithSoftwareInformation(descriptor);
        }
        return success;
    }

    public boolean isSoftwareInformationSet() {
        return this.softwareDescriptor.get() != null;
    }

    public void setSoftwareInformation(String vendor, String product) {
        if (!this.trySettingSoftwareInformation(vendor, product)) {
            throw new IllegalStateException("Software information is already set to: " + this.softwareDescriptor.get());
        }
    }

    SoftwareDescriptor getSoftwareDescriptor() {
        Optional<SoftwareDescriptor> descriptor = Optional.ofNullable(this.softwareDescriptor.get());
        return descriptor.orElse(SoftwareDescriptor.create(null, null));
    }

    void resetSoftwareInformation() {
        this.softwareDescriptor.set(null);
        this.updateLicenseReaderWithSoftwareInformation(null);
    }

    private void updateLicenseReaderWithSoftwareInformation(SoftwareDescriptor descriptor) {
        LicenseReader.getInstance().setLicenseContextFilterInformation(descriptor);
    }

    static {
        System.setProperty("java.net.useSystemProxies", "true");
    }

    final class InternalLicenseUsageChecker {
        private final StackWalker walker = StackWalker.getInstance();

        InternalLicenseUsageChecker() {
        }

        public boolean isLicensed(String product, long time, Class<?> classDeniedInternalUsage) {
            Map<String, Long> internalUsages = LicenseHandler.this.internalLicenseUsages.get(product);
            if (internalUsages == null) {
                return false;
            }
            for (String environment : internalUsages.keySet()) {
                if (classDeniedInternalUsage != null && environment.equals(classDeniedInternalUsage.getName()) || !this.isLegalEnvironment(environment) || time > internalUsages.get(environment)) continue;
                verifyLogger.fine(() -> "License environment checker passed: " + product);
                return true;
            }
            return false;
        }

        public boolean isLegalEnvironment(String environment) {
            LicenseThread licenseThread;
            Thread thread = Thread.currentThread();
            if (thread instanceof LicenseThread && (licenseThread = (LicenseThread)thread).getCallStackSet().contains(environment)) {
                return true;
            }
            return this.isInCallStack(environment);
        }

        private List<String> getCallStackList() {
            ArrayList collector = new ArrayList();
            this.walker.forEach(clazz -> collector.add(clazz.getClassName()));
            return Collections.unmodifiableList(collector);
        }

        private boolean isInCallStack(String environment) {
            boolean[] result = new boolean[]{false};
            this.walker.forEach(frame -> {
                if (frame.getClassName().equals(environment)) {
                    result[0] = true;
                }
            });
            return result[0];
        }
    }

    private static class SingletonHolder {
        private static final LicenseHandler INSTANCE = new LicenseHandler();

        private SingletonHolder() {
        }
    }
}

