/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

import chemaxon.license.LicenseReader;
import chemaxon.license.XMLReader;
import java.util.HashSet;
import java.util.Set;

public class LicenseExceptionHandler {
    static final String LICENSE_FILE_NOT_FOUND = "No license file was found";
    static final String LICENSE_PROBLEM = "No valid license has been found";
    static final String REMOTE_CHECK_FAILURE = "The license server did not validate the academic licenses";
    static final String VERIFICATION_TIMEOUT = "Reading one or more license file has caused a time out after " + XMLReader.LICENSE_READ_TIME_LIMIT + " milliseconds. It probably means that (at least) one of the license files' size is unexpectedly big.\n";
    public static final String LICENSE_CONTACT = "Please visit https://docs.chemaxon.com/display/docs/about-chemaxon-licensing.md or contact sales@chemaxon.com to obtain the corresponding license.\n";
    static final String LICENSE_CONTACT_HTML = "Please visit <a href=\"https://docs.chemaxon.com/display/docs/about-chemaxon-licensing.md\">This link</a> or contact <a href=\"mailto:sales@chemaxon.com\">sales@chemaxon.com</a> to obtain the corresponding license.<br>\n";
    private boolean licenseEverRead = false;
    private boolean remoteCheckFailed = false;
    private final Set<String> permissionProblems = new HashSet<String>();
    private boolean licenseReadingHasTimeouted = false;

    protected LicenseExceptionHandler() {
    }

    public void setRemoteLicenseCheckFailed(boolean b) {
        this.remoteCheckFailed = b;
    }

    public void setLicenseVerificationHasTimeouted(boolean licenseReadingHasTimeouted) {
        this.licenseReadingHasTimeouted = licenseReadingHasTimeouted;
    }

    public static LicenseExceptionHandler getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void setLicenseRead(boolean read) {
        this.licenseEverRead = read;
    }

    public String generateMessage(String product) {
        return this.generateMessage(product, this.getProblemMessage());
    }

    public String generateMessage(String product, String problemMessage) {
        return problemMessage + ".\nProduct name: " + product + "\n" + this.generateLicensePathMessage() + LICENSE_CONTACT;
    }

    public String getProblemMessage() {
        StringBuilder sb = new StringBuilder();
        if (!this.licenseEverRead) {
            sb.append(LICENSE_FILE_NOT_FOUND);
        }
        if (!this.permissionProblems.isEmpty()) {
            sb.append("The following permission problems are found that may caused the failure:\n");
            for (String permissionProblem : this.permissionProblems) {
                sb.append(permissionProblem).append("\n");
            }
        }
        if (this.licenseReadingHasTimeouted) {
            sb.append(VERIFICATION_TIMEOUT);
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        if (this.remoteCheckFailed) {
            return REMOTE_CHECK_FAILURE;
        }
        return LICENSE_PROBLEM;
    }

    private String generateLicensePathMessage() {
        return "Licenses are read from: " + LicenseReader.getInstance().getFullLicensePath() + "\n";
    }

    public String getLicenseExceptionMessage() {
        return "No valid license has been found.\nPlease visit https://docs.chemaxon.com/display/docs/about-chemaxon-licensing.md or contact sales@chemaxon.com to obtain the corresponding license.\n";
    }

    public String getLicenseExceptionMessage(String product) {
        return "No valid license has been found for " + product + ".\nPlease visit https://docs.chemaxon.com/display/docs/about-chemaxon-licensing.md or contact sales@chemaxon.com to obtain the corresponding license.\n";
    }

    void addPermissionProblem(String permissionProblem) {
        this.permissionProblems.add(permissionProblem);
    }

    void clearCache() {
        this.setLicenseRead(false);
        this.permissionProblems.clear();
        this.licenseReadingHasTimeouted = false;
    }

    private static class SingletonHolder {
        private static final LicenseExceptionHandler INSTANCE = new LicenseExceptionHandler();

        private SingletonHolder() {
        }
    }
}

