/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

import chemaxon.license.License;
import chemaxon.license.LicenseGlobals;
import chemaxon.license.LicensePackages;
import chemaxon.license.Ruleset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

final class LicenseConverter {
    private static final String CHEM_CURATOR_LICENSE_ENVIRONMENT = "ChemCuratorLicenseEnvironment";
    private static final String CHEM_LOCATOR_LICENSE_ENVIRONMENT = "ChemLocatorLicenseEnvironment";
    private static final String CHEMAXON_GUI_LICENSE_ENVIRONMENT = "ChemaxonGuiLicenseEnvironment";
    private static final String COMPLIANCE_CHECKER_LICENSE_ENVIRONMENT = "ComplianceCheckerLicenseEnvironment";
    private static final String COMPREG_LICENSE_ENVIRONMENT = "CompRegLicenseEnvironment";
    private static final String FREE_MARKUSH_ENUMERATION_FOR_INTERNAL_USE_LICENSE_ENVIRONMENT = "FreeMarkushEnumerationForInternalUseLicenseEnvironment";
    private static final String HTS_LICENSE_ENVIRONMENT = "HtsLicenseEnvironment";
    private static final String INSTANT_JCHEM_LICENSE_ENVIRONMENT = "InstantJChemLicenseEnvironment";
    private static final String JCHEM_CHORAL_LICENSE_ENIVRONMENT = "JChemChoralLicenseEnvironment";
    private static final String JCHEM_POSTGRES_CARTRIDGE_LICENSE_ENVIRONMENT = "JChemPostgresCartridgeLicenseEnvironment";
    private static final String JCHEM_FOR_OFFICE_LICENSE_ENVIRONMENT = "JChemForOfficeLicenseEnvironment";
    private static final String JCHEM_FOR_SHARE_POINT_LICENSE_ENVIRONMENT = "JChemForSharePointLicenseEnvironment";
    private static final String JCHEM_MICROSERVICES_LICENSE_ENVIRONMENT = "JwsMicroLicenseEnvironment";
    private static final String JCHEM_NEO4J_LICENSE_ENIVRONMENT = "JChemNeo4jLicenseEnvironment";
    private static final String JCHEM_ORACLE_CARTRIDGE_LICENSE_ENVIRONMENT = "JChemOracleCartridgeLicenseEnvironment";
    private static final String KNIME_LICENSE_ENVIRONMENT = "KNIMELicenseEnvironment";
    private static final String LICENSE_ENVIRONMENT_FOR_FREE_ISOMERS_INTERNAL_USAGE = "LicenseEnvironmentForFreeIsomersInternalUsage";
    private static final String MARKUSH_EDITOR_LICENSE_ENVIRONMENT = "MarkushEditorLicenseEnvironment";
    private static final String PLEXUS_SUITE_LICENSE_ENVIRONMENT = "Plexus Suite";
    private static final String STRUCTURE_SEARCH_FOR_INTERNAL_MOL_SEARCH_LICENSE_ENVIRONMENT = "StructureSearchForInternalMolSearchLicenseEnvironment";
    private static final String TAYLOR_AND_FRANCIS_PUBLICATION_LICENSE_ENVIRONMENT = "TaylorAndFrancisPublicationLicenseEnvironment";
    private static final String TRAINER_PLUGIN_LICENSE_ENVIRONMENT = "TrainerPluginLicenseEnvironment";
    private static final String REACTOR_CLASS = "chemaxon.reaction.ReactorTask";
    private static final String CARTRIDGE_STUB_CLASS = "chemaxon.license.util.CartridgeStub";
    private static final String ALIGNMENT_PLUGIN_CLASS = "chemaxon.marvin.calculations.AlignmentPlugin";
    private static final String ALIGNMENT_PLUGIN_DISPLAY_CLASS = "com.chemaxon.calculations.gui.display.AlignmentPluginDisplay";
    private static final String ALIGNMENT_PLUGIN_MOLFACTORY_CLASS = "chemaxon.marvin.alignment.AlignmentMoleculeFactory";
    private static final String ALIGNMENTFORMSPACE_CLASS = "chemaxon.marvin.space.gui.AlignmentForMSpace";
    private static final String ATOM_INDEX_LABELLER_CLASS = "chemaxon.marvin.modules.AtomIndexLabeller";
    private static final String BBB_FUNCTION_CLASS = "chemaxon.calculations.bbb.BBBFunction";
    private static final String BCUT_CLASS = "chemaxon.descriptors.BCUT";
    private static final String CHECKER_STATUSBAR_CLASS = "chemaxon.marvin.sketch.swing.modules.checker.CheckerStatusbarComponent";
    private static final String CNS_MPO_FUNCTION_CLASS = "chemaxon.calculations.cnsmpo.CnsMpoFunction";
    private static final String DIPOLE_CALCULATOR_DISPLAY_CLASS = "chemaxon.calculations.ui.dipole.DipoleCalculatorDisplay";
    private static final String DND_HANDLER_CLASS = "chemaxon.marvin.common.swing.DnD";
    private static final String ECFP_CLASS = "chemaxon.descriptors.ECFP";
    private static final String EDIT_MOLFILE_FRAME_CLASS = "chemaxon.marvin.common.swing.modules.EditMolfileFrame";
    private static final String ELEMENTAL_ANALYSIS_FACTORY_CLASS = "com.chemaxon.calculations.elemanal.factory.ElementalAnalysisFactory";
    private static final String EXPANSION_GRAPH_UTIL_CLASS = "chemaxon.markush.graph.ExpansionGraphUtil";
    private static final String FRAGMENT_BASED_SOLUBILITY_CALCULATOR_CLASS = "com.chemaxon.calculations.solubility.fragments.FragmentBasedSolubilityCalculator";
    private static final String FREE_LOAD_SAVE_CLASS = "chemaxon.marvin.common.swing.modules.FreeLoadSave";
    private static final String GRAPHIC_SCENE_CLASS = "chemaxon.marvin.space.GraphicScene";
    private static final String HERG_PREDICTOR_CLASS = "com.chemaxon.calculations.admet.Predictor";
    private static final String IUPAC_NUMBERING_GENERATOR_CLASS = "chemaxon.naming.s2n.IupacNumberingGenerator";
    private static final String JCHEM_SEARCH_CLASS = "chemaxon.jchem.db.JChemSearch";
    private static final String LIBRARYMCS_BACKEND_CLASS = "chemaxon.clustering.jklustor.backend.LibraryMCS";
    private static final String LIBRARYMCS_CLASS = "chemaxon.clustering.libmcs.LibraryMcs";
    private static final String LICENSE_ENVIRONMENT_ACCEPTANCE_TEST_CLASS = "chemaxon.license.LicenseEnvironmentAcceptanceTest";
    private static final String LOGP_PLUGIN_CLASS = "chemaxon.marvin.calculations.logPPlugin";
    private static final String MAJORMICROSPECIESACCESSORPLUGIN_CLASS = "chemaxon.marvin.calculations.MajorMicrospeciesAccessorPlugin";
    private static final String MAJORMICROSPECIESPLUGIN_CLASS = "chemaxon.marvin.calculations.MajorMicrospeciesPlugin";
    private static final String MAP_ACTION_CLASS = "chemaxon.standardizer.actions.MapAction";
    private static final String MAP_REACTION_ACTION_CLASS = "chemaxon.standardizer.actions.MapReactionAction";
    private static final String MAP_REACTION_FIXER_CLASS = "chemaxon.fixers.MapReactionFixer";
    private static final String MARKUSH_AROMATA_CLASS = "chemaxon.enumeration.supergraph.MarkushAromata";
    private static final String MARVIN_STRING_TRANSFERABLE = "chemaxon.marvin.modules.datatransfer.transferables.StringTransferable";
    private static final String MAX_CLIQUE_MCSBASED_MAPPER_MODULE_CLASS = "chemaxon.automapper.MaxCliqueMCSBasedMapperModule";
    private static final String MDPARAMETERS_CLASS = "chemaxon.descriptors.MDParameters";
    private static final String MOL_EDITOR_CLASS = "chemaxon.marvin.sketch.MolEditor";
    private static final String MOL_SEARCH_CLASS = "chemaxon.sss.search.MolSearch";
    private static final String MOL_SET_SEARCH_CLASS = "chemaxon.jchem.base.search.MolSetSearch";
    private static final String MOLALIGNER_CLASS = "chemaxon.marvin.alignment.MolAligner";
    private static final String MOLECULAR_FORMULAS_CLASS = "com.chemaxon.calculations.elemanal.factory.MolecularFormulas";
    private static final String MOLECULE_VIEWER_CLASS = "chemaxon.marvin.common.swing.MoleculeViewer";
    private static final String MSPACE_PLUGIN_ALIGNMENT_CLASS = "chemaxon.marvin.space.MSpacePluginAlignment";
    private static final String NAME_LICENSER_TEST_CLASS = "chemaxon.license.NameLicenserTest";
    private static final String NAME_TO_STRUCTURE_CONVERT_CLASS = "chemaxon.naming.n2s.SystematicConverter";
    private static final String NAMING_OSR_CLASS = "chemaxon.naming.document.osr.Osr";
    private static final String NMR_CALCULATOR_CLASS = "chemaxon.calculations.nmr.NMRCalculator";
    private static final String NMR_SPECTRUM_CLASS = "chemaxon.calculations.nmr.NMRSpectrum";
    private static final String NMR_TAUTOMERCALCULATORDISPLAY_CLASS = "chemaxon.calculations.ui.nmr.tautomers.TautomerCalculatorDisplay";
    private static final String NMRCALCULATOR_DISPLAY_CLASS = "chemaxon.calculations.ui.nmr.NMRCalculatorDisplay";
    private static final String NMRSOLVENT_DICTIONARY_CLASS = "chemaxon.calculations.ui.nmr.solvents.NMRSolventDictionary";
    private static final String NORMALIZER_RULE_CLASS = "com.chemaxon.zetor.plugins.rule.NormalizerRule";
    private static final String PASTE_ACTION_CLASS = "chemaxon.marvin.swing.action.PasteAction";
    private static final String PHARMACOFORE_CLASS = "chemaxon.descriptors.PharmacophoreFingerprint";
    private static final String PKAPLUGIN_CLASS = "chemaxon.marvin.calculations.pKaPlugin";
    private static final String PMAPPER_CLASS = "chemaxon.pharmacophore.PMapper";
    private static final String POPUPFORMSPACE_CLASS = "chemaxon.marvin.space.gui.JMSpaceTreePopup";
    private static final String REACTANT_SEARCHER_CLASS = "com.chemaxon.transformer.ReactantSearcher";
    private static final String REACTION_CLASS = "chemaxon.reaction.Reaction";
    private static final String REACTIONSEARCH_CLASS = "chemaxon.sss.search.ReactionSearch";
    private static final String REACTOR_STUB_CLASS = "chemaxon.license.util.ReactorStub";
    private static final String RFGENERATOR_CLASS = "chemaxon.descriptors.RFGenerator";
    private static final String MARKUSH_CHECKER_CLASS = "chemaxon.enumeration.MarkushChecker";
    private static final String RGDECOMP_CLASS = "chemaxon.sss.search.RGroupDecomposition";
    private static final String RING_ANALYZER_CLASS = "chemaxon.calculations.RingAnalyzer";
    private static final String SEARCH_UTIL_CLASS = "chemaxon.sss.search.SearchUtil";
    private static final String SKETCH_PANEL_CLASS = "chemaxon.marvin.sketch.swing.SketchPanel";
    private static final String SMARTS_ENUMERATON_CLASS = "chemaxon.marvin.io.formats.smiles.SmartsEnumeration";
    private static final String SOLUBILITY_ACTION_CLASS = "chemaxon.marvin.sketch.swing.actions.calculation.SolubilityAction";
    private static final String SOLUBILITY_CALCULATOR_CLASS = "com.chemaxon.calculations.solubility.SolubilityCalculator";
    private static final String SOLUBILITY_CALCULATOR_DISPLAY_CLASS = "chemaxon.calculations.ui.solubility.SolubilityCalculatorDisplay";
    private static final String STANDARDIZER_ACTION_CLASS = "chemaxon.standardizer.AbstractStandardizerAction";
    private static final String STRUCTURAL_FRAMEWORKS_PLUGIN_CLASS = "chemaxon.marvin.calculations.StructuralFrameworksPlugin";
    private static final String SUBSTRUCTURE_CHECKER_CLASS = "chemaxon.checkers.SubstructureChecker";
    private static final String TAUTOMER_CALCULATOR_DISPLAY_CLASS = "chemaxon.calculations.ui.nmr.tautomers.TautomerCalculatorDisplay";
    private static final String TAUTOMER_INFO_CLASS = "chemaxon.calculations.ui.nmr.tautomers.TautomerInfo";
    private static final String TAUTOMER_STANDARDIZER_ACTION_CLASS = "chemaxon.standardizer.actions.TautomerizeAction";
    private static final String TAUTOMERTABLE_CLASS = "chemaxon.calculations.ui.nmr.tautomers.TautomerTable";
    private static final String TRANSFORM_HANDLER_CLASS = "com.chemaxon.transformer.TransformHandler";
    private static final String TRANSPORT_RECORD_TO_MOLECULE_RECORD_CLASS = "com.chemaxon.jchem.indexing.server.config.TransportRecordToMoleculeRecord";
    private static final String VIEW_PANEL_CLASS = "chemaxon.marvin.view.swing.ViewPanel";
    private static final String ZETOR_SERVICE_CLASS = "com.chemaxon.jchem.indexing.server.ZetorService";
    private static final String INPUT_ENV = "$";
    private final boolean addTestLicenses;
    private final Map<String, Map<EditionAndEnvironment, List<String>>> implications = new HashMap<String, Map<EditionAndEnvironment, List<String>>>();
    private final Map<String, Ruleset.JChemSearchPerMin> jChemSearchPerMin = new HashMap<String, Ruleset.JChemSearchPerMin>();

    private LicenseConverter(boolean addTestLicenses) {
        this.addTestLicenses = addTestLicenses;
        this.addAlwaysRules();
        this.addImplicationRules();
    }

    static Ruleset createRuleset(boolean addTestLicenses) {
        return new LicenseConverter(addTestLicenses).createRuleset();
    }

    private Ruleset createRuleset() {
        return new Ruleset(this.implications.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> LicenseConverter.toImplicationRules((Map)e.getValue()))), this.jChemSearchPerMin);
    }

    private static List<Ruleset.ImplicationRule> toImplicationRules(Map<EditionAndEnvironment, List<String>> map) {
        return map.entrySet().stream().map(e -> new Ruleset.ImplicationRule(((EditionAndEnvironment)e.getKey()).inEditions(), ((EditionAndEnvironment)e.getKey()).inEnvironment(), (List)e.getValue())).toList();
    }

    private void addAlwaysRules() {
        this.always(SOLUBILITY_CALCULATOR_DISPLAY_CLASS, "Solubility Plugin");
        this.always(NMRCALCULATOR_DISPLAY_CLASS, "NMR Predictor");
        this.always(NMRSOLVENT_DICTIONARY_CLASS, "NMR Predictor");
        this.always(TAUTOMER_INFO_CLASS, "NMR Predictor");
        this.always("chemaxon.calculations.ui.nmr.tautomers.TautomerCalculatorDisplay", "Isomers Plugin Group");
        this.always(DIPOLE_CALCULATOR_DISPLAY_CLASS, "Charge Plugin Group");
        this.always(ALIGNMENT_PLUGIN_CLASS, "MCES");
        for (String plugin : LicenseGlobals.PLUGINS) {
            this.always(SKETCH_PANEL_CLASS, plugin);
            if (plugin.equals("Structure to Name")) continue;
            this.always(VIEW_PANEL_CLASS, plugin);
        }
        this.always(SKETCH_PANEL_CLASS, "Markush Enumeration Plugin");
        this.always(VIEW_PANEL_CLASS, "Markush Enumeration Plugin");
        this.always(SKETCH_PANEL_CLASS, "Structure to Name");
        this.always(MOL_EDITOR_CLASS, "Structure to Name");
        this.always(ATOM_INDEX_LABELLER_CLASS, "Structure to Name");
        this.always(VIEW_PANEL_CLASS, "Structure to Name");
        this.always(EDIT_MOLFILE_FRAME_CLASS, "Structure to Name");
        this.always(FREE_LOAD_SAVE_CLASS, "Structure to Name");
        this.always(ALIGNMENT_PLUGIN_DISPLAY_CLASS, "Structure to Name");
        this.always(MSPACE_PLUGIN_ALIGNMENT_CLASS, "Structure to Name");
        this.always(MARVIN_STRING_TRANSFERABLE, "Structure to Name");
        this.always(SKETCH_PANEL_CLASS, "Name to Structure");
        this.always(PASTE_ACTION_CLASS, "Name to Structure");
        this.always(EDIT_MOLFILE_FRAME_CLASS, "Name to Structure");
        this.always(MOLECULE_VIEWER_CLASS, "Name to Structure");
        this.always(FREE_LOAD_SAVE_CLASS, "Name to Structure");
        this.always(DND_HANDLER_CLASS, "Name to Structure");
        this.always(ALIGNMENT_PLUGIN_MOLFACTORY_CLASS, "Geometry Plugin Group");
        this.always(LOGP_PLUGIN_CLASS, "Isomers Plugin Group");
        this.always(GRAPHIC_SCENE_CLASS, "Charge Plugin Group");
        this.always(CHECKER_STATUSBAR_CLASS, "Structure Checker");
        this.always(EXPANSION_GRAPH_UTIL_CLASS, "Structure Checker");
        this.always(TAUTOMER_STANDARDIZER_ACTION_CLASS, "Isomers Plugin Group");
        this.always(TAUTOMERTABLE_CLASS, "Isomers Plugin Group");
        this.always(BCUT_CLASS, "HBDA Plugin");
        this.always(BCUT_CLASS, "Charge Plugin Group");
        this.always(BCUT_CLASS, "Isomers Plugin Group");
        this.always(PHARMACOFORE_CLASS, "HBDA Plugin");
        this.always(PHARMACOFORE_CLASS, "Protonation Plugin Group");
        this.always(PHARMACOFORE_CLASS, "Charge Plugin Group");
        this.always(PHARMACOFORE_CLASS, "Standardizer");
        this.always(PMAPPER_CLASS, "HBDA Plugin");
        this.always(PMAPPER_CLASS, "Protonation Plugin Group");
        this.always(PMAPPER_CLASS, "Charge Plugin Group");
        this.always(PMAPPER_CLASS, "Standardizer");
        this.always(PKAPLUGIN_CLASS, "Isomers Plugin Group");
        this.always(MAJORMICROSPECIESPLUGIN_CLASS, "Isomers Plugin Group");
        this.always(MAJORMICROSPECIESACCESSORPLUGIN_CLASS, "Protonation Plugin Group");
        this.always(NAME_TO_STRUCTURE_CONVERT_CLASS, "Structure Checker");
        this.always(LICENSE_ENVIRONMENT_FOR_FREE_ISOMERS_INTERNAL_USAGE, "Isomers Plugin Group");
        this.always(SMARTS_ENUMERATON_CLASS, "Markush Enumeration Plugin");
        this.always(FREE_MARKUSH_ENUMERATION_FOR_INTERNAL_USE_LICENSE_ENVIRONMENT, "Markush Enumeration Plugin");
        this.always(STRUCTURE_SEARCH_FOR_INTERNAL_MOL_SEARCH_LICENSE_ENVIRONMENT, "Structure Search");
        this.always(MOLALIGNER_CLASS, "3D Alignment");
        String dockingForMSpaceClass = "chemaxon.marvin.space.gui.DockingForMSpace";
        this.always(dockingForMSpaceClass, "3D Alignment");
        this.always(ALIGNMENTFORMSPACE_CLASS, "3D Alignment");
        this.always(POPUPFORMSPACE_CLASS, "Structure Checker");
        this.always(REACTIONSEARCH_CLASS, "Reactor");
        this.always(LIBRARYMCS_CLASS, "Standardizer");
        this.always(LIBRARYMCS_CLASS, "MCES");
        this.always(LIBRARYMCS_BACKEND_CLASS, "MCES");
        this.always(MARKUSH_AROMATA_CLASS, "Markush Enumeration Plugin");
        this.always(MARKUSH_CHECKER_CLASS, "Markush Enumeration Plugin");
        this.always(RGDECOMP_CLASS, "Structure Search");
        this.always(MAX_CLIQUE_MCSBASED_MAPPER_MODULE_CLASS, "MCES");
        this.always(REACTOR_CLASS, "Automapper");
        this.always(REACTION_CLASS, "Automapper");
        this.always(MAP_ACTION_CLASS, "Automapper");
        this.always(MAP_REACTION_ACTION_CLASS, "Automapper");
        this.always(MAP_REACTION_FIXER_CLASS, "Automapper");
        this.always(RFGENERATOR_CLASS, "Automapper");
        this.always(TRANSFORM_HANDLER_CLASS, "Automapper");
        this.always(SEARCH_UTIL_CLASS, "Automapper");
        this.always(SKETCH_PANEL_CLASS, "Automapper");
        this.always(VIEW_PANEL_CLASS, "Automapper");
        this.always(SUBSTRUCTURE_CHECKER_CLASS, "Structure Search");
        this.always(REACTANT_SEARCHER_CLASS, "Structure Search");
        this.always(MDPARAMETERS_CLASS, "Standardizer");
        this.always(STRUCTURAL_FRAMEWORKS_PLUGIN_CLASS, "MCES");
        this.always(RING_ANALYZER_CLASS, "Geometry Plugin Group");
        this.always(JCHEM_SEARCH_CLASS, "Structure Search");
        this.always(JCHEM_SEARCH_CLASS, "Markush Enumeration Plugin");
        this.always(MOL_SET_SEARCH_CLASS, "Structure Search");
        this.always(MOL_SET_SEARCH_CLASS, "Markush Enumeration Plugin");
        this.always(MOL_SEARCH_CLASS, "Markush Enumeration Plugin");
        this.always(NAMING_OSR_CLASS, "Structure Checker");
        this.always(TAYLOR_AND_FRANCIS_PUBLICATION_LICENSE_ENVIRONMENT, "JChem Base");
        this.always(TAYLOR_AND_FRANCIS_PUBLICATION_LICENSE_ENVIRONMENT, "Marvin Beans");
        this.always(JCHEM_ORACLE_CARTRIDGE_LICENSE_ENVIRONMENT, "JChem Base");
        this.always(CHEMAXON_GUI_LICENSE_ENVIRONMENT, "Marvin Beans");
        this.always(JCHEM_FOR_OFFICE_LICENSE_ENVIRONMENT, "Marvin Beans");
        this.always(INSTANT_JCHEM_LICENSE_ENVIRONMENT, "Marvin Beans");
        this.always(INSTANT_JCHEM_LICENSE_ENVIRONMENT, "JChem Base");
        this.always(INSTANT_JCHEM_LICENSE_ENVIRONMENT, "Structure Search");
        this.always(INSTANT_JCHEM_LICENSE_ENVIRONMENT, "MCES");
        this.always(KNIME_LICENSE_ENVIRONMENT, "Marvin Beans");
        this.always(FRAGMENT_BASED_SOLUBILITY_CALCULATOR_CLASS, "Structure Search");
        this.always(FRAGMENT_BASED_SOLUBILITY_CALCULATOR_CLASS, "Geometry Plugin Group");
        this.always(SOLUBILITY_CALCULATOR_CLASS, "Protonation Plugin Group");
        this.always(SOLUBILITY_ACTION_CLASS, "Solubility Plugin");
        if (this.addTestLicenses) {
            this.always(LICENSE_ENVIRONMENT_ACCEPTANCE_TEST_CLASS, "Reactor");
            this.always(NAME_LICENSER_TEST_CLASS, "Structure to Name");
        }
        this.always(ELEMENTAL_ANALYSIS_FACTORY_CLASS, "Markush Enumeration Plugin");
        this.always(MOLECULAR_FORMULAS_CLASS, "Markush Enumeration Plugin");
        this.always(HERG_PREDICTOR_CLASS, "Trainer Plugin");
        this.always(HERG_PREDICTOR_CLASS, "Partitioning Plugin Group");
        this.always(HERG_PREDICTOR_CLASS, "Protonation Plugin Group");
        this.always(HERG_PREDICTOR_CLASS, "Geometry Plugin Group");
        this.always(HERG_PREDICTOR_CLASS, "Charge Plugin Group");
        this.always(HERG_PREDICTOR_CLASS, "Solubility Plugin");
        this.always(HERG_PREDICTOR_CLASS, "HBDA Plugin");
        this.always(HERG_PREDICTOR_CLASS, "Huckel Analysis Plugin");
        this.always(HERG_PREDICTOR_CLASS, "ECFP/FCFP");
        this.always(HERG_PREDICTOR_CLASS, "Structure Search");
        this.always(HERG_PREDICTOR_CLASS, "Standardizer");
        this.always(CNS_MPO_FUNCTION_CLASS, "Partitioning Plugin Group");
        this.always(CNS_MPO_FUNCTION_CLASS, "Protonation Plugin Group");
        this.always(CNS_MPO_FUNCTION_CLASS, "HBDA Plugin");
        this.always(BBB_FUNCTION_CLASS, "Protonation Plugin Group");
        this.always(BBB_FUNCTION_CLASS, "Geometry Plugin Group");
        this.always(BBB_FUNCTION_CLASS, "HBDA Plugin");
    }

    private void addImplicationRules() {
        this.addScreenLicenseRules();
        this.addReactorLicenseRules("Reactor");
        this.addJKlustorLicenseRules();
        this.addStandardizerLicenseRules();
        this.addFragmenterLicenseRules();
        this.addJChemBaseLicenseRules("JChem Base", INPUT_ENV);
        this.addJChemCartridgeLicenseRules();
        this.addPostgresCartridgeLicenseRules();
        this.addMolsearchLicenseRules();
        this.addAlignmentLicenseRules();
        this.addIJCLicenseRules("Instant JChem");
        this.addIJCStructuralBundleLicenseRules("IJC Structural Bundle");
        this.addIJCMedicinalChemistryBundleLicenseRules("IJC Medicinal Chemistry Bundle");
        this.addIJCComputationalChemistryBundleLicenseRules();
        this.addJChemForExcelLicenseRules();
        this.addJChemForOfficeLicenseRules("JChem for Office");
        this.addJChemForOfficeLiteLicenseRules("JChem for Office Lite");
        this.addMarkushSearchLicenseRules();
        this.addStructuralCalculationsLicenseRules();
        this.addCalculationsPackLicenseRules();
        this.addJChemForSharePointLicenseRules();
        this.addJChemForSharePointSearchLicenseRules();
        this.addChemLocatorPersonalLicenseRules();
        this.addChemLocatorServerLicenseRules();
        this.addDocumentToStructureLicenseRules();
        this.addScreen3DLicenseRules();
        this.addECFP_FCFPLicenseRules();
        this.addMolecularDescriptorLicenseRules();
        this.addRegistrationSystemLicenseRules();
        this.addNMRLicenseRules();
        this.addMarkushEditorLicenseRules();
        this.addChemCuratorCompoundLicenseRules();
        this.addChemCuratorFullLicenseRules();
        this.addNameToStructureLicenseRules();
        this.addBiomoleculeToolkitLicenseRules();
        this.addPlexusConnectLicenseRules("Plexus Connect");
        this.addPlexusRegistrationLicenseRules();
        this.addPlexusDesignLicenseRules();
        this.addPlexusAnalysisLicenseRules();
        this.addMarvinJSLicenseRules();
        this.addOverlapLicenseRules();
        this.addComplianceCheckerLicenseRules();
        this.addJChemMicroservicesLicenseRules();
        this.addJChemMicroservicesDbLicenseRules();
        this.addJChemMicroservicesMarkushLicenseRules();
        this.addJChemMicroservicesStructureCheckerLicenseRules();
        this.addJChemMicroservicesReactorLicenseRules();
        this.addChoralLicenseRules();
        this.addNeo4jLicenseRules();
        this.addHtsLicenseRules();
        this.addJC4OBasicBundleLicenseRules("JC4O Basic Bundle");
        this.addJC4OStructuralBundleLicenseRules("JC4O Structural Bundle");
        this.addJC4OMedicinalBundleLicenseRules("JC4O Medicinal Chemistry Bundle");
        this.addJC4ODiscoveryBundleLicenseRules();
        this.addMarvinPresenterBundleLicenseRules();
        this.addMarvinForOfficeBundleLicenseRules();
        this.addChemistryForOfficeBundleLicenseRules();
        this.addMarvinProLicenseRules();
        this.addTrainerPluginLicenseRules();
    }

    private void addMarvinJSLicenseRules() {
        this.implication("Marvin for JavaScript", INPUT_ENV, "Automapper");
    }

    private void addChemCuratorCompoundLicenseRules() {
        this.addChemCuratorCommonLicenseRules("ChemCurator Compound");
    }

    private void addChemCuratorFullLicenseRules() {
        this.implication("ChemCurator Full", CHEM_CURATOR_LICENSE_ENVIRONMENT, "Markush Editor");
        this.addChemCuratorCommonLicenseRules("ChemCurator Full");
    }

    private void addChemCuratorCommonLicenseRules(String license) {
        this.implication(license, CHEM_CURATOR_LICENSE_ENVIRONMENT, "Marvin Beans");
        this.implication(license, CHEM_CURATOR_LICENSE_ENVIRONMENT, "Markush Enumeration Plugin");
        this.implication(license, CHEM_CURATOR_LICENSE_ENVIRONMENT, "Structure Checker");
        this.implication(license, CHEM_CURATOR_LICENSE_ENVIRONMENT, "Structure Search");
        this.implication(license, CHEM_CURATOR_LICENSE_ENVIRONMENT, "Markush Search");
        this.implication(license, CHEM_CURATOR_LICENSE_ENVIRONMENT, "MCES");
        this.implication(license, CHEM_CURATOR_LICENSE_ENVIRONMENT, "HBDA Plugin");
        this.implication(license, CHEM_CURATOR_LICENSE_ENVIRONMENT, "Structure to Name");
        this.implication(license, CHEM_CURATOR_LICENSE_ENVIRONMENT, "Name to Structure");
        this.implication(license, CHEM_CURATOR_LICENSE_ENVIRONMENT, "Document to Structure");
    }

    private void addNameToStructureLicenseRules() {
        this.implication("Name to Structure", IUPAC_NUMBERING_GENERATOR_CLASS, "Structure to Name");
    }

    private void addScreen3DLicenseRules() {
        this.implication("3D Screen", INPUT_ENV, "3D Alignment");
        this.implication("3D Screen", INPUT_ENV, "MCES");
        this.implication("3D Screen", INPUT_ENV, "Geometry Plugin Group");
    }

    private void addScreenLicenseRules() {
        this.implication("Screen", INPUT_ENV, "Optimize Metrics");
    }

    private void addReactorLicenseRules(String license) {
        this.implication(license, INPUT_ENV, "Reactor");
        List<String> editions = List.of("Professional", "Unspecified Edition");
        this.implication(license, editions, INPUT_ENV, "Synthesizer");
        this.implication(license, editions, REACTOR_CLASS, "Standardizer");
        this.implication(license, editions, REACTOR_CLASS, "Structure Search");
        if (this.addTestLicenses) {
            this.implication(license, editions, CARTRIDGE_STUB_CLASS, "Reactor");
            this.implication(license, editions, REACTOR_STUB_CLASS, "Structure Search");
        }
        for (String plugin : LicenseGlobals.PLUGINS) {
            this.implication(license, editions, REACTOR_CLASS, plugin);
        }
    }

    private void addJKlustorLicenseRules() {
        this.implication("JKlustor", INPUT_ENV, "Molecular Descriptors");
        this.implication("JKlustor", INPUT_ENV, "MCES");
        this.implication("JKlustor", List.of("Standard"), INPUT_ENV, "Pharmacophore Recognition");
        this.implication("JKlustor", List.of("Standard"), INPUT_ENV, "Library MCS");
        this.implication("JKlustor", List.of("Standard"), INPUT_ENV, "Structure Search");
    }

    private void addStandardizerLicenseRules() {
        this.implication("Standardizer", STANDARDIZER_ACTION_CLASS, "Structure Search");
        this.implication("Standardizer", STANDARDIZER_ACTION_CLASS, "Isomers Plugin Group");
        this.implication("Standardizer", INPUT_ENV, "Automapper");
    }

    private void addNMRLicenseRules() {
        this.implication("NMR Predictor", NMR_CALCULATOR_CLASS, "Geometry Plugin Group");
        this.implication("NMR Predictor", NMR_SPECTRUM_CLASS, "Geometry Plugin Group");
        this.implication("NMR Predictor", "chemaxon.calculations.ui.nmr.tautomers.TautomerCalculatorDisplay", "Isomers Plugin Group");
    }

    private void addFragmenterLicenseRules() {
        this.implication("Fragmenter", INPUT_ENV, "Structure Search");
    }

    private void addMolsearchLicenseRules() {
        this.implication("Structure Search", INPUT_ENV, "MCES");
        this.implication("Structure Search", INPUT_ENV, "Marvin Beans");
    }

    private void addAlignmentLicenseRules() {
        this.implication("3D Alignment", INPUT_ENV, "MCES");
        this.implication("3D Alignment", INPUT_ENV, "Geometry Plugin Group");
    }

    private void addJChemBaseLicenseRules(String license, String env) {
        LicensePackages.JCHEM_BASE_LICENSES.forEach(l -> this.implication(license, env, (String)l));
        this.jchemSearchPerMinRule(license, Ruleset.JChemSearchPerMin.AS_SPECIFIED_IN_LICENSE);
    }

    private void addRegistrationSystemLicenseRules() {
        this.implication("Registration System", COMPREG_LICENSE_ENVIRONMENT, "JChem Base");
        this.implication("Registration System", COMPREG_LICENSE_ENVIRONMENT, "Standardizer");
        this.implication("Registration System", COMPREG_LICENSE_ENVIRONMENT, "Structure Checker");
        this.implication("Registration System", COMPREG_LICENSE_ENVIRONMENT, "Structure Search");
        this.implication("Registration System", COMPREG_LICENSE_ENVIRONMENT, "Isomers Plugin Group");
        this.jchemSearchPerMinRule("Registration System", Ruleset.JChemSearchPerMin.UNLIMITED);
    }

    private void addJChemCartridgeLicenseRules() {
        this.implication("JChem Cartridge", INPUT_ENV, "Structure Search");
        this.implication("JChem Cartridge", INPUT_ENV, "Automapper");
        this.implication("JChem Cartridge", INPUT_ENV, "MCES");
    }

    private void addPostgresCartridgeLicenseRules() {
        this.implication("Postgres Cartridge", JCHEM_POSTGRES_CARTRIDGE_LICENSE_ENVIRONMENT, "Geometry Plugin Group");
        this.grantPylonLicenses("Postgres Cartridge", INPUT_ENV);
    }

    private void addJChemForExcelLicenseRules() {
        this.implication("JChem for Excel", JCHEM_FOR_OFFICE_LICENSE_ENVIRONMENT, "Structure Search");
        this.implication("JChem for Excel", JCHEM_FOR_OFFICE_LICENSE_ENVIRONMENT, "MCES");
        this.implication("JChem for Excel", JCHEM_FOR_OFFICE_LICENSE_ENVIRONMENT, "Marvin Beans");
        this.implication("JChem for Excel", JCHEM_FOR_OFFICE_LICENSE_ENVIRONMENT, "ChemAxon .NET API");
    }

    private void addJChemForOfficeLicenseRules(String license) {
        this.implication(license, INPUT_ENV, "JChem for Office");
        this.implication(license, INPUT_ENV, "JChem for Excel");
        LicensePackages.JCHEM_FOR_OFFICE_TECHNICAL_LICENSES.forEach(l -> this.implication(license, JCHEM_FOR_OFFICE_LICENSE_ENVIRONMENT, (String)l));
    }

    private void addJC4OBasicBundleLicenseRules(String license) {
        this.implication(license, INPUT_ENV, "JC4O Basic Bundle");
        this.addJChemForOfficeLicenseRules(license);
        LicensePackages.JCHEM_FOR_OFFICE_BASIC_BUNDLE_TECHNICAL_LICENSES.forEach(l -> this.implication(license, JCHEM_FOR_OFFICE_LICENSE_ENVIRONMENT, (String)l));
    }

    private void addJC4OStructuralBundleLicenseRules(String license) {
        this.implication(license, INPUT_ENV, "JC4O Structural Bundle");
        this.addJC4OBasicBundleLicenseRules(license);
        LicensePackages.JCHEM_FOR_OFFICE_STRUCTURAL_BUNDLE_TECHNICAL_LICENSES.forEach(l -> this.implication(license, JCHEM_FOR_OFFICE_LICENSE_ENVIRONMENT, (String)l));
        LicensePackages.STRUCTURAL_CALCULATIONS_IMPLICATIONS.forEach(l -> this.implication(license, JCHEM_FOR_OFFICE_LICENSE_ENVIRONMENT, (String)l));
    }

    private void addJC4OMedicinalBundleLicenseRules(String license) {
        this.implication(license, INPUT_ENV, "JC4O Medicinal Chemistry Bundle");
        this.addJC4OStructuralBundleLicenseRules(license);
        LicensePackages.JCHEM_FOR_OFFICE_MEDICINAL_CHEMISTRY_BUNDLE_TECHNICAL_LICENSES.forEach(l -> this.implication(license, JCHEM_FOR_OFFICE_LICENSE_ENVIRONMENT, (String)l));
    }

    private void addJC4ODiscoveryBundleLicenseRules() {
        this.addJC4OMedicinalBundleLicenseRules("JC4O Discovery Bundle");
        LicensePackages.JCHEM_FOR_OFFICE_DISCOVERY_BUNDLE_TECHNICAL_LICENSES.forEach(l -> this.implication("JC4O Discovery Bundle", JCHEM_FOR_OFFICE_LICENSE_ENVIRONMENT, (String)l));
        this.implication("JC4O Discovery Bundle", INPUT_ENV, "Synthesizer");
        this.implication("JC4O Discovery Bundle", REACTOR_CLASS, "Standardizer");
        this.implication("JC4O Discovery Bundle", REACTOR_CLASS, "Structure Search");
        this.addCalculatorPlugins("JC4O Discovery Bundle", REACTOR_CLASS);
    }

    private void addMarvinPresenterBundleLicenseRules() {
        this.implication("Marvin Presenter Bundle", INPUT_ENV, "Marvin Beans");
        this.addJChemForOfficeLiteLicenseRules("Marvin Presenter Bundle");
    }

    private void addMarvinForOfficeBundleLicenseRules() {
        this.implication("Marvin for Office Bundle", INPUT_ENV, "Marvin Beans");
        this.addJChemForOfficeLicenseRules("Marvin for Office Bundle");
    }

    private void addChemistryForOfficeBundleLicenseRules() {
        this.implication("Chemistry for Office", INPUT_ENV, "Marvin Beans");
        this.addJChemForOfficeLicenseRules("Chemistry for Office");
        LicensePackages.CHEMISTRY_FOR_OFFICE_BUNDLE_TECHNICAL_LICENSES.forEach(l -> this.implication("Chemistry for Office", JCHEM_FOR_OFFICE_LICENSE_ENVIRONMENT, (String)l));
    }

    private void addJChemForOfficeLiteLicenseRules(String license) {
        this.implication(license, INPUT_ENV, "JChem for Office Lite");
        LicensePackages.JCHEM_FOR_OFFICE_LITE_TECHNICAL_LICENSES.forEach(l -> this.implication(license, JCHEM_FOR_OFFICE_LICENSE_ENVIRONMENT, (String)l));
    }

    private void addMarvinProLicenseRules() {
        LicensePackages.getImplicatedLicenses("Marvin Pro").forEach(l -> this.implication("Marvin Pro", INPUT_ENV, (String)l));
    }

    private void addIJCLicenseRules(String license) {
        this.implication(license, INPUT_ENV, "Instant JChem");
        this.addJChemBaseLicenseRules(license, INSTANT_JCHEM_LICENSE_ENVIRONMENT);
    }

    private void addIJCStructuralBundleLicenseRules(String license) {
        this.implication(license, INPUT_ENV, "IJC Structural Bundle");
        this.addIJCLicenseRules(license);
        LicensePackages.IJC_STRUCTURAL_LICENSES.forEach(l -> this.implication(license, INPUT_ENV, (String)l));
    }

    private void addIJCMedicinalChemistryBundleLicenseRules(String license) {
        this.implication(license, INPUT_ENV, "IJC Medicinal Chemistry Bundle");
        this.addIJCStructuralBundleLicenseRules(license);
        LicensePackages.IJC_MEDICINAL_CHEMISTRY_LICENSES.forEach(l -> this.implication(license, INPUT_ENV, (String)l));
    }

    private void addIJCComputationalChemistryBundleLicenseRules() {
        this.implication("IJC Computational Chemistry Bundle", INPUT_ENV, "IJC Computational Chemistry Bundle");
        this.addIJCMedicinalChemistryBundleLicenseRules("IJC Computational Chemistry Bundle");
        LicensePackages.IJC_COMPUTATIONAL_CHEMISTRY_LICENSES.forEach(l -> this.implication("IJC Computational Chemistry Bundle", INPUT_ENV, (String)l));
    }

    private void addMarkushSearchLicenseRules() {
        this.implication("Markush Search", INPUT_ENV, "Markush Enumeration Plugin");
        this.implication("Markush Search", INPUT_ENV, "Structure Search");
        this.implication("Markush Search", INPUT_ENV, "MCES");
    }

    private void addStructuralCalculationsLicenseRules() {
        LicensePackages.getImplicatedLicenses("Structural Calculations").forEach(l -> this.implication("Structural Calculations", INPUT_ENV, (String)l));
    }

    private void addCalculationsPackLicenseRules() {
        this.implication("Calculations Pack", JCHEM_FOR_OFFICE_LICENSE_ENVIRONMENT, "Standardizer");
        this.addCalculatorPlugins("Calculations Pack", JCHEM_FOR_OFFICE_LICENSE_ENVIRONMENT);
    }

    private void addECFP_FCFPLicenseRules() {
        this.addCalculatorPlugins("ECFP/FCFP", ECFP_CLASS);
    }

    private void addMolecularDescriptorLicenseRules() {
        this.implication("Molecular Descriptors", INPUT_ENV, "Pharmacophore Recognition");
        this.implication("Molecular Descriptors", INPUT_ENV, "Structure Search");
    }

    private void addJChemForSharePointLicenseRules() {
        this.implication("JChem for SharePoint", JCHEM_FOR_SHARE_POINT_LICENSE_ENVIRONMENT, "Structure Search");
        this.implication("JChem for SharePoint", JCHEM_FOR_SHARE_POINT_LICENSE_ENVIRONMENT, "MCES");
    }

    private void addJChemForSharePointSearchLicenseRules() {
        this.implication("JChem for SharePoint Search", JCHEM_FOR_SHARE_POINT_LICENSE_ENVIRONMENT, "Structure Search");
        this.implication("JChem for SharePoint Search", JCHEM_FOR_SHARE_POINT_LICENSE_ENVIRONMENT, "MCES");
        this.implication("JChem for SharePoint Search", JCHEM_FOR_SHARE_POINT_LICENSE_ENVIRONMENT, "JChem Base");
        this.jchemSearchPerMinRule("JChem for SharePoint Search", Ruleset.JChemSearchPerMin.UNLIMITED);
    }

    private void addChemLocatorPersonalLicenseRules() {
        this.addChemLocatorLicenses("ChemLocator Personal");
    }

    private void addChemLocatorLicenses(String license) {
        this.implication(license, CHEM_LOCATOR_LICENSE_ENVIRONMENT, "Structure Search");
        this.implication(license, CHEM_LOCATOR_LICENSE_ENVIRONMENT, "MCES");
        this.implication(license, CHEM_LOCATOR_LICENSE_ENVIRONMENT, "JChem Base");
        this.implication(license, CHEM_LOCATOR_LICENSE_ENVIRONMENT, "Document to Structure");
        this.implication(license, CHEM_LOCATOR_LICENSE_ENVIRONMENT, "Name to Structure");
        this.implication(license, CHEM_LOCATOR_LICENSE_ENVIRONMENT, "Structure to Name");
        this.implication(license, CHEM_LOCATOR_LICENSE_ENVIRONMENT, "JChem for Office Java API");
        this.jchemSearchPerMinRule(license, Ruleset.JChemSearchPerMin.UNLIMITED);
    }

    private void addChemLocatorServerLicenseRules() {
        this.addChemLocatorLicenses("ChemLocator Server");
    }

    private void addDocumentToStructureLicenseRules() {
        this.implication("Document to Structure", INPUT_ENV, "Name to Structure");
    }

    private void addMarkushEditorLicenseRules() {
        this.implication("Markush Editor", MARKUSH_EDITOR_LICENSE_ENVIRONMENT, "Marvin Beans");
        this.implication("Markush Editor", MARKUSH_EDITOR_LICENSE_ENVIRONMENT, "Markush Enumeration Plugin");
        this.implication("Markush Editor", MARKUSH_EDITOR_LICENSE_ENVIRONMENT, "Structure Checker");
        this.implication("Markush Editor", MARKUSH_EDITOR_LICENSE_ENVIRONMENT, "Structure Search");
        this.implication("Markush Editor", MARKUSH_EDITOR_LICENSE_ENVIRONMENT, "Markush Search");
        this.implication("Markush Editor", MARKUSH_EDITOR_LICENSE_ENVIRONMENT, "MCES");
        this.implication("Markush Editor", MARKUSH_EDITOR_LICENSE_ENVIRONMENT, "HBDA Plugin");
        this.implication("Markush Editor", MARKUSH_EDITOR_LICENSE_ENVIRONMENT, "Standardizer");
        this.implication("Markush Editor", MARKUSH_EDITOR_LICENSE_ENVIRONMENT, "Structure to Name");
    }

    private void addBiomoleculeToolkitLicenseRules() {
        this.implication("Biomolecule Toolkit", INPUT_ENV, "Marvin Applets");
        this.implication("Biomolecule Toolkit", INPUT_ENV, "JChem Base");
        this.implication("Biomolecule Toolkit", INPUT_ENV, "Structure Search");
        this.jchemSearchPerMinRule("Biomolecule Toolkit", Ruleset.JChemSearchPerMin.UNLIMITED);
    }

    private void addPlexusConnectLicenseRules(String license) {
        this.implication(license, INPUT_ENV, "Plexus Connect");
        this.implication(license, INPUT_ENV, "Instant JChem");
        this.addJChemBaseLicenseRules(license, PLEXUS_SUITE_LICENSE_ENVIRONMENT);
        this.jchemSearchPerMinRule(license, Ruleset.JChemSearchPerMin.UNLIMITED);
    }

    private void addPlexusRegistrationLicenseRules() {
        this.addPlexusConnectLicenseRules("Plexus Registration");
    }

    private void addPlexusDesignLicenseRules() {
        this.addPlexusConnectLicenseRules("Plexus Design");
        this.addCalculatorPlugins("Plexus Design", PLEXUS_SUITE_LICENSE_ENVIRONMENT);
        this.implication("Plexus Design", "", "Markush Enumeration Plugin");
        this.addReactorLicenseRules("Plexus Design");
    }

    private void addPlexusAnalysisLicenseRules() {
        this.addPlexusConnectLicenseRules("Plexus Analysis");
        for (String plugin : LicenseGlobals.PLUGINS) {
            if (plugin.equals("Markush Enumeration Plugin")) continue;
            this.implication("Plexus Analysis", PLEXUS_SUITE_LICENSE_ENVIRONMENT, plugin);
        }
    }

    private void addOverlapLicenseRules() {
        this.implication("Overlap", INPUT_ENV, "MadFast");
    }

    private void addComplianceCheckerLicenseRules() {
        this.implication("Compliance Checker", COMPLIANCE_CHECKER_LICENSE_ENVIRONMENT, "ECFP/FCFP");
        this.grantCCRelatedLicenses("Compliance Checker", COMPLIANCE_CHECKER_LICENSE_ENVIRONMENT);
    }

    private void addHtsLicenseRules() {
        this.implication("HTS Code Generator", HTS_LICENSE_ENVIRONMENT, "HTS Code Generator");
        this.implication("HTS Code Generator", HTS_LICENSE_ENVIRONMENT, "Structural Frameworks Plugin");
        this.grantCCRelatedLicenses("HTS Code Generator", HTS_LICENSE_ENVIRONMENT);
    }

    private void grantCCRelatedLicenses(String license, String environment) {
        this.implication(license, environment, "Standardizer");
        this.implication(license, environment, "Markush Enumeration Plugin");
        this.implication(license, environment, "Structure to Name");
        this.implication(license, environment, "Name to Structure");
        this.implication(license, environment, "Structure to Name");
        this.implication(license, environment, "Structure Search");
        this.implication(license, environment, "Markush Search");
        this.implication(license, environment, "Web Services Server");
        this.implication(license, environment, "Structure Checker");
        this.implication(license, environment, "JChem for Excel");
        this.implication(license, environment, "Marvin for JavaScript");
    }

    private void addJChemMicroservicesLicenseRules() {
        this.implication("JChem Microservices", JCHEM_MICROSERVICES_LICENSE_ENVIRONMENT, "JChem Microservices");
        this.implication("JChem Microservices", INPUT_ENV, "JChem Microservices Base");
        for (String module : LicenseGlobals.MODULES) {
            String license = License.canonicalNameWithModule("JChem Microservices", module);
            this.implication(license, JCHEM_MICROSERVICES_LICENSE_ENVIRONMENT, license);
        }
        String jwsDb = License.canonicalNameWithModule("JChem Microservices", "JWS DB");
        this.implication(jwsDb, INPUT_ENV, "JChem Pylon");
        this.implication(jwsDb, NORMALIZER_RULE_CLASS, "Standardizer");
        this.implication(jwsDb, TRANSPORT_RECORD_TO_MOLECULE_RECORD_CLASS, "Standardizer");
        this.implication(jwsDb, ZETOR_SERVICE_CLASS, "Structure Search");
    }

    private void addJChemMicroservicesDbLicenseRules() {
        this.implication("JChem Microservices DB", INPUT_ENV, "JChem Microservices");
        this.implication("JChem Microservices DB", INPUT_ENV, "JChem Microservices Base");
        this.implication("JChem Microservices DB", JCHEM_MICROSERVICES_LICENSE_ENVIRONMENT, "JChem Microservices DB");
        this.grantPylonLicenses("JChem Microservices DB", JCHEM_MICROSERVICES_LICENSE_ENVIRONMENT);
        this.implication("JChem Microservices DB", JCHEM_MICROSERVICES_LICENSE_ENVIRONMENT, "Structure Search");
    }

    private void addJChemMicroservicesMarkushLicenseRules() {
        this.implication("JChem Microservices Markush Enumeration", INPUT_ENV, "JChem Microservices Base");
        this.implication("JChem Microservices Markush Enumeration", JCHEM_MICROSERVICES_LICENSE_ENVIRONMENT, "Markush Enumeration Plugin");
        this.implication("JChem Microservices Markush Enumeration", JCHEM_MICROSERVICES_LICENSE_ENVIRONMENT, "Structure Search");
    }

    private void addJChemMicroservicesStructureCheckerLicenseRules() {
        this.implication("JChem Microservices Structure Checker", INPUT_ENV, "JChem Microservices Structure Checker");
        this.implication("JChem Microservices Structure Checker", INPUT_ENV, "JChem Microservices Base");
        this.implication("JChem Microservices Structure Checker", INPUT_ENV, "Structure Checker");
    }

    private void addJChemMicroservicesReactorLicenseRules() {
        this.implication("JChem Microservices Reactor", INPUT_ENV, "JChem Microservices Base");
        this.addReactorLicenseRules("JChem Microservices Reactor");
    }

    private void addChoralLicenseRules() {
        this.implication("JChem Choral", JCHEM_CHORAL_LICENSE_ENIVRONMENT, "JChem Choral");
        this.implication("JChem Choral", JCHEM_CHORAL_LICENSE_ENIVRONMENT, "Geometry Plugin Group");
        this.grantPylonLicenses("JChem Choral", JCHEM_CHORAL_LICENSE_ENIVRONMENT);
    }

    private void addNeo4jLicenseRules() {
        this.implication("JChem Neo4j", JCHEM_NEO4J_LICENSE_ENIVRONMENT, "JChem Neo4j");
        this.implication("JChem Neo4j", JCHEM_NEO4J_LICENSE_ENIVRONMENT, "JChem Microservices DB");
        this.grantPylonLicenses("JChem Neo4j", JCHEM_NEO4J_LICENSE_ENIVRONMENT);
    }

    private void addTrainerPluginLicenseRules() {
        this.addCalculatorPlugins("Trainer Plugin", TRAINER_PLUGIN_LICENSE_ENVIRONMENT);
        this.implication("Trainer Plugin", TRAINER_PLUGIN_LICENSE_ENVIRONMENT, "ECFP/FCFP");
        this.implication("Trainer Plugin", TRAINER_PLUGIN_LICENSE_ENVIRONMENT, "Structure Search");
        this.implication("Trainer Plugin", TRAINER_PLUGIN_LICENSE_ENVIRONMENT, "MadFast");
        this.implication("Trainer Plugin", TRAINER_PLUGIN_LICENSE_ENVIRONMENT, "Standardizer");
        this.implication("Trainer Plugin", TRAINER_PLUGIN_LICENSE_ENVIRONMENT, "Marvin for JavaScript");
    }

    private void grantPylonLicenses(String license, String env) {
        this.implication(license, env, "JChem Pylon");
        this.implication(license, NORMALIZER_RULE_CLASS, "Standardizer");
        this.implication(license, TRANSPORT_RECORD_TO_MOLECULE_RECORD_CLASS, "Standardizer");
        this.implication(license, ZETOR_SERVICE_CLASS, "Structure Search");
    }

    private void addCalculatorPlugins(String license, String env) {
        for (String plugin : LicenseGlobals.PLUGINS) {
            this.implication(license, env, plugin);
        }
    }

    private void always(String inEnvironment, String implicates) {
        this.implication("Free Plugin", inEnvironment, implicates);
    }

    private void implication(String license, String inEnvironment, String implicates) {
        this.implication(license, List.of(), inEnvironment, implicates);
    }

    private void implication(String license, List<String> inEditions, String inEnvironment, String implicates) {
        Objects.requireNonNull(license);
        Objects.requireNonNull(inEnvironment);
        if (Objects.equals(license, implicates) && INPUT_ENV.equals(inEnvironment)) {
            return;
        }
        if ("Free Plugin".equals(implicates)) {
            return;
        }
        EditionAndEnvironment ee = new EditionAndEnvironment(inEditions.isEmpty() ? null : String.join((CharSequence)",", inEditions), INPUT_ENV.equals(inEnvironment) ? null : inEnvironment);
        this.implications.computeIfAbsent(license, k -> new HashMap()).computeIfAbsent(ee, k -> new ArrayList()).add(implicates);
    }

    private void jchemSearchPerMinRule(String license, Ruleset.JChemSearchPerMin thenTheLimit) {
        this.jChemSearchPerMin.put(license, thenTheLimit);
    }

    private record EditionAndEnvironment(String inEditions, String inEnvironment) {
    }
}

