/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

import chemaxon.license.LicenseGlobals;
import chemaxon.license.LicenseValidationState;
import com.chemaxon.version.VersionInfo;
import java.lang.invoke.CallSite;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class License
implements Cloneable,
Comparable<License> {
    private static final System.Logger generalLogger = System.getLogger("cxl.license.general");
    public static final String ROOT = "ChemAxon";
    public static final String LICENSE_TAG = "License";
    public static final String NOTE = "PLEASE DO NOT MODIFY THIS FILE AND BE AWARE THAT THE FILE CONTAINS CONFIDENTIAL INFORMATION.";
    public static final String SOFTWARE = "Software";
    public static final String LICENSE_TERM = "License Term";
    public static final String LICENSEE = "Licensee";
    public static final String LICENSED_UNIT_COUNT = "Number of Users";
    public static final String EXPIRATION_DATE = "Expiration Date";
    public static final String SUPPORT_EXPIRATION_DATE = "Support Expiration Date";
    public static final String PARENT_EXPIRATION_DATE = "Parent Expiration Date";
    public static final String RESTRICTION = "Restriction";
    public static final String BSP_RESTRICTION = "B/S/P";
    public static final String BSPE_RESTRICTION = "B/S/P/E";
    public static final String GUI_API_RESTRICTION = "GUI/API";
    public static final String SEARCH_PER_MIN_RESTRICTION = "Search/Min";
    public static final String INTEGRATED = "Integrated With";
    public static final String SERVER_USE = "Server Use";
    public static final String MODULE_RESTRICTION = "Modules";
    public static final String BASIC = "Basic";
    public static final String STANDARD = "Standard";
    public static final String PROFESSIONAL = "Professional";
    public static final String ENTERPRISE = "Enterprise";
    public static final String UNSPECIFIED_EDITION = "Unspecified Edition";
    public static final String LICENSE_TERM_ANNUAL = "Annual";
    public static final String LICENSE_TERM_PERPETUAL = "Perpetual";
    public static final String LICENSE_TERM_EVALUATION = "Evaluation";
    public static final String LICENSE_TERM_ACADEMIC_RESEARCH = "Academic Research";
    public static final String LICENSE_TERM_ACADEMIC_TEACHING = "Academic Teaching";
    public static final String LICENSE_TERM_ACADEMIC = "Academic";
    static final String LICENSE_TERM_FREE = "Free";
    public static final String COMMENT = "Comment";
    public static final String HARDWARE = "Hardware";
    public static final String SIGNATURE = "Signature";
    public static final String DEFAULT_LICENSED_UNIT_COUNT = "Unlimited";
    public static final String SEARCH_PER_MIN_UNLIMITED = "Unlimited";
    public static final String NEVER_EXPIRES = "Never";
    public static final String SERVER_USE_ALLOWED = "Allowed";
    public static final String SERVER_USE_NOT_ALLOWED = "Not Allowed";
    public static final String VALIDATION = "Validation";
    private Map<String, String> fields;
    private Map<String, String> restrictions;
    private final String signature;
    private final long aboutToExpiration;
    private final long exactExpiration;
    private final long supportExpiration;
    private final long buildDateInMillis;
    private static final int EVALUATION_MAXIMAL_VALIDITY_IN_MONTH = 3;
    private static final int TEMPORARY_EXTENDED_ANNUAL_MAXIMAL_VALIDITY_IN_MONTH = 66;
    private static final int GENERAL_MAXIMAL_VALIDITY_IN_MONTH = 30;
    static final String ALWAYS_GRANTED_SOFTWARE = "Free Plugin";
    static final License ALWAYS_GRANTED_LICENSE = License.builder().setSoftware("Free Plugin").setLicenseTerm("Free").setLicensee("All Users").setLicensedUnitCount("Unlimited").setExpirationDate("Never").setSupportExpirationDate("Never").build();

    public License clone() throws CloneNotSupportedException {
        License clone = (License)super.clone();
        clone.fields = new HashMap<String, String>(this.fields);
        clone.restrictions = new HashMap<String, String>(this.restrictions);
        return clone;
    }

    public String getLicenseData() {
        ArrayList<CallSite> licenseDataElements = new ArrayList<CallSite>();
        Object licenseData = "";
        for (Map.Entry<String, String> entry : this.fields.entrySet()) {
            licenseDataElements.add((CallSite)((Object)(entry.getKey() + "=" + entry.getValue())));
        }
        for (Map.Entry<String, String> entry : this.restrictions.entrySet()) {
            licenseDataElements.add((CallSite)((Object)(entry.getKey() + "=" + entry.getValue())));
        }
        Collections.sort(licenseDataElements);
        for (String string : licenseDataElements) {
            licenseData = (String)licenseData + string + "\n";
        }
        return licenseData;
    }

    public String toString() {
        Object licenseData = "";
        for (Map.Entry<String, String> nameAndValue : this.fields.entrySet()) {
            licenseData = (String)licenseData + nameAndValue.getKey() + ": " + nameAndValue.getValue() + "\n";
        }
        for (Map.Entry<String, String> restriction : this.restrictions.entrySet()) {
            licenseData = (String)licenseData + restriction.getKey() + ": " + restriction.getValue() + "\n";
        }
        return licenseData;
    }

    public Set<String> getFieldNames() {
        return this.fields.keySet();
    }

    public String getFieldValue(String fName) {
        return this.fields.get(fName);
    }

    public String getSoftware() {
        return this.getFieldValue(SOFTWARE);
    }

    public Stream<String> getSoftwareAndModules() {
        String software = this.getSoftware();
        String modules = this.getRestriction(MODULE_RESTRICTION);
        if (modules == null) {
            return Stream.of(software);
        }
        Set entries = Arrays.stream(modules.split(",")).map(String::trim).map(String::toLowerCase).collect(Collectors.toSet());
        Stream<String> withModules = LicenseGlobals.MODULES.stream().filter(m -> entries.contains(m.toLowerCase())).map(m -> License.canonicalNameWithModule(software, m));
        return Stream.concat(Stream.of(software), withModules);
    }

    public static String canonicalNameWithModule(String software, String module) {
        return software + " with " + module;
    }

    public String getLicenseTerm() {
        return this.getFieldValue(LICENSE_TERM);
    }

    public String getLicensee() {
        return this.getFieldValue(LICENSEE);
    }

    public String getLicensedUnitCount() {
        return this.getFieldValue(LICENSED_UNIT_COUNT);
    }

    public String getExpirationDate() {
        return this.getFieldValue(EXPIRATION_DATE);
    }

    public String getSupportExpirationDate() {
        return this.getFieldValue(SUPPORT_EXPIRATION_DATE);
    }

    public String getParentExpirationDate() {
        return this.getFieldValue(PARENT_EXPIRATION_DATE);
    }

    public String getSignature() {
        return this.signature;
    }

    public Set<String> getRestrictionNames() {
        return this.restrictions.keySet();
    }

    public String getRestriction(String rName) {
        return this.restrictions.get(rName);
    }

    public String getRestrictions() {
        StringBuilder res = new StringBuilder();
        for (Map.Entry<String, String> restriction : this.restrictions.entrySet()) {
            res.append(restriction.getKey()).append(": ").append(restriction.getValue()).append(" \n");
        }
        return res.toString();
    }

    public LicenseValidationState getValidationState() {
        long timeStamp = System.currentTimeMillis();
        if (this.isExpired(timeStamp)) {
            return LicenseValidationState.EXPIRED;
        }
        if (this.isAboutToExpire(timeStamp)) {
            return LicenseValidationState.ABOUT_TO_EXPIRE;
        }
        if (this.isInvalid(timeStamp)) {
            return LicenseValidationState.INVALID;
        }
        return LicenseValidationState.VALID;
    }

    public boolean isExpired() {
        return LicenseValidationState.EXPIRED == this.getValidationState();
    }

    public boolean isAboutToExpire() {
        return LicenseValidationState.ABOUT_TO_EXPIRE == this.getValidationState();
    }

    public boolean isInvalid() {
        return LicenseValidationState.INVALID == this.getValidationState();
    }

    public boolean isValid() {
        return LicenseValidationState.VALID == this.getValidationState();
    }

    private boolean isExpired(long timeStamp) {
        return timeStamp >= this.exactExpiration || this.buildDateInMillis >= this.supportExpiration;
    }

    private boolean isInvalid(long timeStamp) {
        return false;
    }

    private boolean isValidForTooLong(long timeStamp, int maximalValidityInMonth) {
        Calendar supportExpDate = Calendar.getInstance();
        supportExpDate.setTimeInMillis(this.supportExpiration);
        supportExpDate.add(2, -maximalValidityInMonth);
        return supportExpDate.getTimeInMillis() - timeStamp > 0L;
    }

    private boolean isAboutToExpire(long timeStamp) {
        return timeStamp < this.exactExpiration && timeStamp >= this.aboutToExpiration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        License license = (License)o;
        return this.fields.equals(license.fields) && this.restrictions.equals(license.restrictions);
    }

    public int hashCode() {
        int result = this.fields.hashCode();
        result = 31 * result + this.restrictions.hashCode();
        result = 31 * result + (this.signature != null ? this.signature.hashCode() : 0);
        result = 31 * result;
        return result;
    }

    @Override
    public int compareTo(License o) {
        Date otherExpTime = License.getSupportExpirationAsDate(o);
        Date expTime = License.getSupportExpirationAsDate(this);
        return expTime.compareTo(otherExpTime);
    }

    public static Date getSupportExpirationAsDate(License o) {
        Date expTime;
        String date = o.getSupportExpirationDate();
        if (date.equalsIgnoreCase(NEVER_EXPIRES)) {
            date = "3000-12-31";
        }
        SimpleDateFormat sdf = License.getDateFormat();
        try {
            expTime = sdf.parse(date);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return expTime;
    }

    public long getExpirationTime() {
        return switch (this.getValidationState()) {
            default -> throw new IncompatibleClassChangeError();
            case LicenseValidationState.VALID, LicenseValidationState.ABOUT_TO_EXPIRE -> this.exactExpiration;
            case LicenseValidationState.EXPIRED, LicenseValidationState.INVALID -> -1L;
        };
    }

    static LicenseBuilder builder() {
        return new LicenseBuilder();
    }

    private License(LicenseBuilder builder) {
        this.fields = builder.fields;
        this.restrictions = builder.restrictions;
        this.signature = builder.signature;
        SimpleDateFormat sdf = License.getDateFormat();
        Calendar expDate = Calendar.getInstance();
        Calendar parentExpDate = Calendar.getInstance();
        Calendar supportExpDate = Calendar.getInstance();
        try {
            if (this.getExpirationDate().equalsIgnoreCase(NEVER_EXPIRES)) {
                expDate.setTime(new Date(Long.MAX_VALUE));
                this.exactExpiration = Long.MAX_VALUE;
            } else {
                expDate.setTime(sdf.parse(this.getExpirationDate()));
                expDate.add(5, 1);
                this.exactExpiration = expDate.getTimeInMillis();
            }
            if (this.getSupportExpirationDate().equalsIgnoreCase(NEVER_EXPIRES)) {
                supportExpDate.setTime(new Date(Long.MAX_VALUE));
            } else {
                supportExpDate.setTime(sdf.parse(this.getSupportExpirationDate()));
                supportExpDate.add(5, 1);
            }
            if (this.getFieldNames().contains(PARENT_EXPIRATION_DATE)) {
                if (this.getParentExpirationDate().equalsIgnoreCase(NEVER_EXPIRES)) {
                    parentExpDate.setTime(new Date(Long.MAX_VALUE));
                } else {
                    parentExpDate.setTime(sdf.parse(this.getParentExpirationDate()));
                }
            } else {
                parentExpDate = expDate;
            }
        }
        catch (ParseException e) {
            generalLogger.log(System.Logger.Level.INFO, "License can not be parsed.", (Throwable)e);
            throw new IllegalStateException("License can not be parsed", e);
        }
        this.supportExpiration = supportExpDate.getTimeInMillis();
        if (!LICENSE_TERM_EVALUATION.equals(this.getLicenseTerm())) {
            parentExpDate.add(5, -30);
        }
        this.aboutToExpiration = parentExpDate.getTimeInMillis();
        Calendar buildDate = Calendar.getInstance();
        buildDate.setTime(VersionInfo.getBuildTimestamp());
        this.buildDateInMillis = buildDate.getTimeInMillis();
    }

    public static SimpleDateFormat getDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
    }

    static class LicenseBuilder {
        private final Map<String, String> fields = new HashMap<String, String>();
        private final Map<String, String> restrictions = new HashMap<String, String>();
        private String signature;

        private LicenseBuilder() {
        }

        License build() {
            return new License(this);
        }

        LicenseBuilder setField(String name, String value) {
            this.fields.put(name, value);
            return this;
        }

        LicenseBuilder setSoftware(String software) {
            return this.setField(License.SOFTWARE, software);
        }

        LicenseBuilder setLicenseTerm(String licenseTerm) {
            return this.setField(License.LICENSE_TERM, licenseTerm);
        }

        LicenseBuilder setLicensee(String licensee) {
            return this.setField(License.LICENSEE, licensee);
        }

        LicenseBuilder setLicensedUnitCount(String licensedUnitCount) {
            return this.setField(License.LICENSED_UNIT_COUNT, licensedUnitCount);
        }

        LicenseBuilder setExpirationDate(String expirationDate) {
            return this.setField(License.EXPIRATION_DATE, expirationDate);
        }

        LicenseBuilder setSupportExpirationDate(String supportExpirationDate) {
            return this.setField(License.SUPPORT_EXPIRATION_DATE, supportExpirationDate);
        }

        LicenseBuilder setParentExpirationDate(String parentExpirationDate) {
            return this.setField(License.PARENT_EXPIRATION_DATE, parentExpirationDate);
        }

        LicenseBuilder setSignature(String signature) {
            this.signature = signature;
            return this;
        }

        LicenseBuilder setRestriction(String name, String value) {
            this.restrictions.put(name, value);
            return this;
        }
    }
}

