/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

import chemaxon.license.JsonChecksumCalculator;
import chemaxon.license.TelemetryFileHandler;
import chemaxon.license.audit.UserDataEntry;
import chemaxon.license.audit.UserDataRepository;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import org.json.JSONObject;

class FileUserDataRepository
implements UserDataRepository {
    private final TelemetryFileHandler fileHandler;
    private final JsonChecksumCalculator checksumCalculator;

    public FileUserDataRepository(TelemetryFileHandler fileHandler, JsonChecksumCalculator checksumCalculator) {
        this.fileHandler = fileHandler;
        this.checksumCalculator = checksumCalculator;
    }

    public void save(UserDataEntry userDataEntry) {
        try {
            if (userDataEntry == null) {
                return;
            }
            JSONObject jsonData = userDataEntry.userData();
            jsonData.put("sessionId", (Object)userDataEntry.sessionId());
            jsonData.put("createdDate", (Object)userDataEntry.createdDate());
            jsonData.put("checksum", (Object)this.checksumCalculator.calculate(jsonData));
            this.fileHandler.write(jsonData);
        }
        catch (IOException | InterruptedException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Can not save user data to file.", e);
        }
    }

    public Iterable<UserDataEntry> getOldestEntriesWithLicenseKey(int count) {
        return this.fileHandler.getUserDataEntriesAndArchive(count);
    }

    public void deleteMany(Iterable<String> sessionIds) {
        this.fileHandler.tryDeleteUserDataRecords(sessionIds);
    }
}

