/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

import chemaxon.license.JsonChecksumCalculator;
import chemaxon.license.TelemetryFileHandler;
import chemaxon.license.TelemetryJsonUtil;
import chemaxon.license.audit.LicenseUsageEntry;
import chemaxon.license.audit.LicenseUsageRepository;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDateTime;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

class FileLicenseUsageRepository
implements LicenseUsageRepository {
    static Logger telemetryLogger = Logger.getLogger("cxl.license.telemetry");
    private final String sessionId;
    private final TelemetryFileHandler fileHandler;
    private final JsonChecksumCalculator checksumCalculator;

    public FileLicenseUsageRepository(String sessionId, TelemetryFileHandler fileHandler, JsonChecksumCalculator checksumCalculator) {
        this.fileHandler = fileHandler;
        this.sessionId = sessionId;
        this.checksumCalculator = checksumCalculator;
    }

    public void save(LicenseUsageEntry licenseUsageEntry) {
        try {
            if (licenseUsageEntry == null) {
                return;
            }
            JSONObject jsonData = TelemetryJsonUtil.getJsonObject(licenseUsageEntry);
            jsonData.put("createdDate", (Object)LocalDateTime.now());
            jsonData.put("checksum", (Object)this.checksumCalculator.calculate(jsonData));
            this.fileHandler.write(jsonData);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Can not save license usage to file.", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            telemetryLogger.log(Level.INFO, "Saving license usage was interrupted.");
        }
    }

    public Iterable<LicenseUsageEntry> getOldestEntriesWithLicenseKey(int count) {
        return this.fileHandler.getLicenseUsageEntriesAndArchive(this.sessionId, count);
    }

    public void deleteMany(Iterable<String> sessionIds) {
        this.fileHandler.tryDeleteLicenseUsageRecords(sessionIds);
    }
}

