/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.http.HttpClient;
import java.time.Duration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class BaseRemoteClient {
    private static final Logger generalLogger = Logger.getLogger("cxl.license.general");
    protected final String server;
    private final int clientTimeoutSec;

    BaseRemoteClient(String server, int clientTimeoutSec) {
        this.server = server;
        this.clientTimeoutSec = clientTimeoutSec;
        this.checkArguments();
    }

    private void checkArguments() {
        if (this.server == null) {
            throw new IllegalArgumentException("Invalid arguments. Server can not be null.");
        }
    }

    protected HttpClient createClient() {
        ProxySelector proxySelector = ProxySelector.getDefault() == null ? new NoProxySelector() : ProxySelector.getDefault();
        return HttpClient.newBuilder().proxy(proxySelector).followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(Duration.ofSeconds(this.clientTimeoutSec)).build();
    }

    private static class NoProxySelector
    extends ProxySelector {
        private NoProxySelector() {
        }

        @Override
        public List<Proxy> select(URI uri) {
            return List.of(Proxy.NO_PROXY);
        }

        @Override
        public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
            generalLogger.log(Level.INFO, ioe, () -> "Connection failed with NoProxySelector. Uri: " + uri + " socket address: " + sa);
        }
    }
}

